/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.enums;

import com.regnosys.rosetta.generator.java.RObjectJavaClassGenerator;
import com.regnosys.rosetta.generator.java.scoping.JavaClassScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RJavaEnum;
import com.regnosys.rosetta.generator.java.types.RJavaEnumValue;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaEnumSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import com.rosetta.model.lib.annotations.RosettaSynonym;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;

public class EnumGenerator
extends RObjectJavaClassGenerator<REnumType, RJavaEnum> {
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private ModelGeneratorUtil _modelGeneratorUtil;
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;

    @Override
    protected Stream<? extends REnumType> streamObjects(RosettaModel model) {
        Predicate<RosettaRootElement> _function = it -> it instanceof RosettaEnumeration;
        Function<RosettaRootElement, RosettaEnumeration> _function_1 = it -> (RosettaEnumeration)it;
        Function<RosettaEnumeration, REnumType> _function_2 = it -> this._rObjectFactory.buildREnumType((RosettaEnumeration)it);
        return model.getElements().stream().filter(_function).map(_function_1).map(_function_2);
    }

    @Override
    protected RJavaEnum createTypeRepresentation(REnumType object) {
        return this._javaTypeTranslator.toJavaReferenceType(object);
    }

    @Override
    protected StringConcatenationClient generate(final REnumType e, final RJavaEnum javaEnum, final String version, JavaClassScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _javadoc = EnumGenerator.this._modelGeneratorUtil.javadoc(e.getEObject().getDefinition(), (List<RosettaDocReference>)e.getEObject().getReferences(), version);
                _builder.append((Object)_javadoc);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(RosettaEnum.class);
                _builder.append((Object)"(\"");
                String _name = e.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public enum ");
                String _name_1 = e.getName();
                _builder.append((Object)_name_1);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                List<RJavaEnumValue> _enumValues = javaEnum.getEnumValues();
                boolean _hasElements = false;
                for (RJavaEnumValue value : _enumValues) {
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",\n", "\t");
                    }
                    _builder.append((Object)"\t");
                    CharSequence _javadoc_1 = EnumGenerator.this._modelGeneratorUtil.javadoc(value.getEObject());
                    _builder.append((Object)_javadoc_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _contributeAnnotations = EnumGenerator.this.contributeAnnotations(value.getEObject());
                    _builder.append((Object)_contributeAnnotations, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(RosettaEnumValue.class, "\t");
                    _builder.append((Object)"(value = \"");
                    String _rosettaName = value.getRosettaName();
                    _builder.append((Object)_rosettaName, "\t");
                    _builder.append((Object)"\"");
                    String _displayName = value.getDisplayName();
                    boolean bl = _tripleNotEquals = _displayName != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)", displayName = \"");
                        String _displayName_1 = value.getDisplayName();
                        _builder.append((Object)_displayName_1, "\t");
                        _builder.append((Object)"\"");
                    }
                    _builder.append((Object)") ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _name_2 = value.getName();
                    _builder.append((Object)_name_2, "\t");
                    _builder.append((Object)"(\"");
                    String _rosettaName_1 = value.getRosettaName();
                    _builder.append((Object)_rosettaName_1, "\t");
                    _builder.append((Object)"\", ");
                    String _displayName_2 = value.getDisplayName();
                    boolean bl2 = _tripleNotEquals_1 = _displayName_2 != null;
                    if (_tripleNotEquals_1) {
                        _builder.append((Object)"\"");
                        String _escapeJava = StringEscapeUtils.escapeJava((String)value.getDisplayName());
                        _builder.append((Object)_escapeJava, "\t");
                        _builder.append((Object)"\"");
                    } else {
                        _builder.append((Object)"null");
                    }
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                if (_hasElements) {
                    _builder.append((Object)";", "\t");
                }
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private static ");
                _builder.append(Map.class, "\t");
                _builder.append((Object)"<");
                _builder.append(String.class, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)javaEnum, "\t");
                _builder.append((Object)"> values;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"static {");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append(Map.class, "        ");
                _builder.append((Object)"<");
                _builder.append(String.class, "        ");
                _builder.append((Object)", ");
                _builder.append((Object)javaEnum, "        ");
                _builder.append((Object)"> map = new ");
                _builder.append(ConcurrentHashMap.class, "        ");
                _builder.append((Object)"<>();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"for (");
                _builder.append((Object)javaEnum, "\t\t");
                _builder.append((Object)" instance : ");
                _builder.append((Object)javaEnum, "\t\t");
                _builder.append((Object)".values()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"map.put(instance.toDisplayString(), instance);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"values = ");
                _builder.append(Collections.class, "\t\t");
                _builder.append((Object)".unmodifiableMap(map);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private final ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" rosettaName;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private final ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" displayName;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)javaEnum, "\t");
                _builder.append((Object)"(");
                _builder.append(String.class, "\t");
                _builder.append((Object)" rosettaName, ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" displayName) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.rosettaName = rosettaName;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.displayName = displayName;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public static ");
                _builder.append((Object)javaEnum, "\t");
                _builder.append((Object)" fromDisplayName(String name) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)javaEnum, "\t\t");
                _builder.append((Object)" value = values.get(name);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (value == null) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"throw new ");
                _builder.append(IllegalArgumentException.class, "\t\t\t");
                _builder.append((Object)"(\"No enum constant with display name \\\"\" + name + \"\\\".\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return value;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" toString() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return toDisplayString();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" toDisplayString() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return displayName != null ?  displayName : rosettaName;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient contributeAnnotations(final com.regnosys.rosetta.rosetta.RosettaEnumValue e) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<RosettaEnumSynonym> _enumSynonyms = e.getEnumSynonyms();
                for (RosettaEnumSynonym synonym : _enumSynonyms) {
                    EList<RosettaSynonymSource> _sources = synonym.getSources();
                    for (RosettaSynonymSource source : _sources) {
                        _builder.append((Object)"@");
                        _builder.append(RosettaSynonym.class);
                        _builder.append((Object)"(value = \"");
                        String _synonymValue = synonym.getSynonymValue();
                        _builder.append((Object)_synonymValue);
                        _builder.append((Object)"\", source = \"");
                        String _name = source.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\")");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        };
        return _client;
    }
}

