/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.scoping.JavaPackageName;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeDeclaration;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public abstract class RGeneratedJavaClass<T>
extends JavaClass<T> {
    private final DottedPath nestedTypeName;
    private final JavaPackageName packageName;

    protected RGeneratedJavaClass(JavaPackageName packageName, DottedPath nestedTypeName) {
        this.packageName = packageName;
        this.nestedTypeName = nestedTypeName;
    }

    public static <U> RGeneratedJavaClass<? extends U> create(JavaPackageName packageName, String simpleName, Class<U> superclassOrInterface) {
        return new SimpleGeneratedJavaClass<U>(packageName, DottedPath.of((String[])new String[]{simpleName}), superclassOrInterface);
    }

    public static <U> RGeneratedJavaClass<? extends U> create(JavaPackageName packageName, String simpleName, TypeReference<U> supertypeRef) {
        return new SimpleGeneratedJavaClass<U>(packageName, DottedPath.of((String[])new String[]{simpleName}), supertypeRef);
    }

    public static <U> RGeneratedJavaClass<? extends U> createWithSuperclass(JavaPackageName packageName, String simpleName, JavaClass<U> superclass) {
        return new SimpleGeneratedJavaClass<U>(packageName, DottedPath.of((String[])new String[]{simpleName}), superclass, null);
    }

    public static <U> RGeneratedJavaClass<? extends U> createImplementingInterface(JavaPackageName packageName, String simpleName, JavaClass<U> interf) {
        return new SimpleGeneratedJavaClass<U>(packageName, DottedPath.of((String[])new String[]{simpleName}), null, interf);
    }

    public <U> RGeneratedJavaClass<? extends U> createNestedClass(String simpleName, Class<U> superclassOrInterface) {
        return new SimpleGeneratedJavaClass<U>(this.packageName, this.getNestedTypeName().child(simpleName), superclassOrInterface);
    }

    public <U> RGeneratedJavaClass<? extends U> createNestedClassWithSuperclass(String simpleName, JavaClass<U> superclass) {
        return new SimpleGeneratedJavaClass<U>(this.packageName, this.getNestedTypeName().child(simpleName), superclass, null);
    }

    public <U> RGeneratedJavaClass<? extends U> createNestedClassImplementingInterface(String simpleName, JavaClass<U> interf) {
        return new SimpleGeneratedJavaClass<U>(this.packageName, this.getNestedTypeName().child(simpleName), null, interf);
    }

    public StringConcatenationClient asClassDeclaration() {
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                List interfaces;
                target.append((Object)"class ");
                target.append((Object)RGeneratedJavaClass.this.getSimpleName());
                JavaClass superclass = RGeneratedJavaClass.this.getSuperclass();
                if (!JavaClass.OBJECT.equals((Object)superclass)) {
                    target.append((Object)" extends ");
                    target.append((Object)superclass);
                }
                if (!(interfaces = RGeneratedJavaClass.this.getInterfaces()).isEmpty()) {
                    target.append((Object)" implements ");
                    target.append(interfaces.get(0));
                    for (int i = 1; i < interfaces.size(); ++i) {
                        target.append((Object)", ");
                        target.append(interfaces.get(i));
                    }
                }
            }
        };
    }

    public StringConcatenationClient asInterfaceDeclaration() {
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)"interface ");
                target.append((Object)RGeneratedJavaClass.this.getSimpleName());
                List interfaces = RGeneratedJavaClass.this.getInterfaces();
                if (!interfaces.isEmpty()) {
                    target.append((Object)" extends ");
                    target.append(interfaces.get(0));
                    for (int i = 1; i < interfaces.size(); ++i) {
                        target.append((Object)", ");
                        target.append(interfaces.get(i));
                    }
                }
            }
        };
    }

    public boolean isSubtypeOf(JavaType other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.getSuperclass().isSubtypeOf(other)) {
            return true;
        }
        return this.getInterfaces().stream().anyMatch(t -> t.isSubtypeOf(other));
    }

    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.getSuperclassDeclaration().extendsDeclaration(other)) {
            return true;
        }
        return this.getInterfaceDeclarations().stream().anyMatch(t -> t.extendsDeclaration(other));
    }

    public DottedPath getNestedTypeName() {
        return this.nestedTypeName;
    }

    public boolean isFinal() {
        return false;
    }

    public Class<? extends T> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Cannot load a generated class");
    }

    public DottedPath getPackageName() {
        return this.packageName.getName();
    }

    public JavaPackageName getEscapedPackageName() {
        return this.packageName;
    }

    private static class SimpleGeneratedJavaClass<U>
    extends RGeneratedJavaClass<U> {
        private final Type supertype;
        private final Class<? super U> rawSupertype;
        private JavaTypeDeclaration<? super U> superclassDeclaration;
        private JavaClass<? super U> superclass;
        private JavaTypeDeclaration<? super U> interfaceDeclaration;
        private JavaClass<? super U> interf;

        private SimpleGeneratedJavaClass(JavaPackageName packageName, DottedPath nestedTypeName, Type supertype, Class<? super U> rawSupertype) {
            super(packageName, nestedTypeName);
            this.supertype = supertype;
            this.rawSupertype = rawSupertype;
        }

        public SimpleGeneratedJavaClass(JavaPackageName packageName, DottedPath nestedTypeName, Class<U> supertype) {
            this(packageName, nestedTypeName, supertype, supertype);
        }

        public SimpleGeneratedJavaClass(JavaPackageName packageName, DottedPath nestedTypeName, TypeReference<U> supertypeRef) {
            this(packageName, nestedTypeName, supertypeRef.getType(), JavaParameterizedType.extractRawClass((Type)supertypeRef.getType()));
        }

        public SimpleGeneratedJavaClass(JavaPackageName packageName, DottedPath nestedTypeName, JavaClass<? super U> superclass, JavaClass<? super U> interf) {
            super(packageName, nestedTypeName);
            JavaParameterizedType t;
            this.supertype = null;
            this.rawSupertype = null;
            if (superclass != null) {
                if (superclass instanceof JavaParameterizedType) {
                    t = (JavaParameterizedType)superclass;
                    this.superclassDeclaration = t.getGenericTypeDeclaration();
                } else {
                    this.superclassDeclaration = superclass;
                }
                this.superclass = superclass;
            }
            if (interf != null) {
                if (interf instanceof JavaParameterizedType) {
                    t = (JavaParameterizedType)interf;
                    this.interfaceDeclaration = t.getGenericTypeDeclaration();
                } else {
                    this.interfaceDeclaration = superclass;
                }
                this.interf = interf;
            }
        }

        public JavaTypeDeclaration<? super U> getSuperclassDeclaration() {
            if (this.rawSupertype != null && this.rawSupertype.isInterface() || this.interfaceDeclaration != null) {
                return JavaClass.OBJECT;
            }
            if (this.superclassDeclaration == null) {
                this.superclassDeclaration = JavaTypeDeclaration.from(this.rawSupertype);
            }
            return this.superclassDeclaration;
        }

        public JavaClass<? super U> getSuperclass() {
            if (this.rawSupertype != null && this.rawSupertype.isInterface() || this.interf != null) {
                return JavaClass.OBJECT;
            }
            if (this.superclass == null) {
                this.superclass = JavaClass.from((Type)this.supertype, Collections.emptyMap());
            }
            return this.superclass;
        }

        public List<JavaTypeDeclaration<?>> getInterfaceDeclarations() {
            if (this.interfaceDeclaration == null && this.rawSupertype != null && this.rawSupertype.isInterface()) {
                this.interfaceDeclaration = JavaTypeDeclaration.from(this.rawSupertype);
            }
            if (this.interfaceDeclaration == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.interfaceDeclaration);
        }

        public List<JavaClass<?>> getInterfaces() {
            if (this.interf == null && this.rawSupertype != null && this.rawSupertype.isInterface()) {
                this.interf = JavaClass.from((Type)this.supertype, Collections.emptyMap());
            }
            if (this.interf == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.interf);
        }
    }
}

