/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.parsing;

import com.google.common.collect.ImmutableSet;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import jakarta.inject.Inject;
import java.util.Set;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public class ValidIDConverter
extends AbstractValueConverter<String> {
    private final ParserRule validIDRule;
    private final Set<String> validKeywordIDs;
    private final IDValueConverter delegate;

    @Inject
    public ValidIDConverter(RosettaGrammarAccess grammarAccess, IDValueConverter delegate) {
        this.validIDRule = grammarAccess.getValidIDRule();
        this.delegate = delegate;
        Alternatives alternatives = (Alternatives)this.validIDRule.getAlternatives();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        alternatives.getElements().stream().skip(1L).forEach(element -> builder.add((Object)((Keyword)element).getValue()));
        this.validKeywordIDs = builder.build();
    }

    public String toValue(String string, INode node) {
        return this.delegate.toValue(string, node);
    }

    public String toString(String value) throws ValueConverterException {
        if (this.validKeywordIDs.contains(value)) {
            return value;
        }
        return this.delegate.toString((Object)value);
    }
}

