/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.meta.DateTimeListMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DateTimeList", builder=DateTimeListBuilderImpl.class, version="5.27.0")
@RuneDataType(value="DateTimeList", model="cdm", builder=DateTimeListBuilderImpl.class, version="5.27.0")
public interface DateTimeList
extends RosettaModelObject {
    public static final DateTimeListMeta metaData = new DateTimeListMeta();

    public List<ZonedDateTime> getDateTime();

    public DateTimeList build();

    public DateTimeListBuilder toBuilder();

    public static DateTimeListBuilder builder() {
        return new DateTimeListBuilderImpl();
    }

    default public RosettaMetaData<? extends DateTimeList> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DateTimeList> getType() {
        return DateTimeList.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, this.getDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DateTimeListBuilderImpl
    implements DateTimeListBuilder {
        protected List<ZonedDateTime> dateTime = new ArrayList<ZonedDateTime>();

        @Override
        @RosettaAttribute(value="dateTime", isRequired=true)
        @RuneAttribute(value="dateTime", isRequired=true)
        public List<ZonedDateTime> getDateTime() {
            return this.dateTime;
        }

        @Override
        @RosettaAttribute(value="dateTime", isRequired=true)
        @RuneAttribute(value="dateTime", isRequired=true)
        public DateTimeListBuilder addDateTime(ZonedDateTime _dateTime) {
            if (_dateTime != null) {
                this.dateTime.add(_dateTime);
            }
            return this;
        }

        @Override
        public DateTimeListBuilder addDateTime(ZonedDateTime _dateTime, int idx) {
            this.getIndex(this.dateTime, idx, () -> _dateTime);
            return this;
        }

        @Override
        public DateTimeListBuilder addDateTime(List<ZonedDateTime> dateTimes) {
            if (dateTimes != null) {
                for (ZonedDateTime toAdd : dateTimes) {
                    this.dateTime.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dateTime")
        public DateTimeListBuilder setDateTime(List<ZonedDateTime> dateTimes) {
            this.dateTime = dateTimes == null ? new ArrayList<ZonedDateTime>() : (List)dateTimes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public DateTimeList build() {
            return new DateTimeListImpl(this);
        }

        @Override
        public DateTimeListBuilder toBuilder() {
            return this;
        }

        @Override
        public DateTimeListBuilder prune() {
            return this;
        }

        public boolean hasData() {
            return this.getDateTime() != null && !this.getDateTime().isEmpty();
        }

        public DateTimeListBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DateTimeListBuilder o = (DateTimeListBuilder)other;
            merger.mergeBasic(this.getDateTime(), o.getDateTime(), this::addDateTime);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DateTimeList _that = this.getType().cast(o);
            return ListEquals.listEquals(this.dateTime, _that.getDateTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DateTimeListBuilder {dateTime=" + this.dateTime + '}';
        }
    }

    public static interface DateTimeListBuilder
    extends DateTimeList,
    RosettaModelObjectBuilder {
        public DateTimeListBuilder addDateTime(ZonedDateTime var1);

        public DateTimeListBuilder addDateTime(ZonedDateTime var1, int var2);

        public DateTimeListBuilder addDateTime(List<ZonedDateTime> var1);

        public DateTimeListBuilder setDateTime(List<ZonedDateTime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, this.getDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DateTimeListBuilder prune();
    }

    public static class DateTimeListImpl
    implements DateTimeList {
        private final List<ZonedDateTime> dateTime;

        protected DateTimeListImpl(DateTimeListBuilder builder) {
            this.dateTime = Optional.ofNullable(builder.getDateTime()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dateTime", isRequired=true)
        @RuneAttribute(value="dateTime", isRequired=true)
        public List<ZonedDateTime> getDateTime() {
            return this.dateTime;
        }

        @Override
        public DateTimeList build() {
            return this;
        }

        @Override
        public DateTimeListBuilder toBuilder() {
            DateTimeListBuilder builder = DateTimeList.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DateTimeListBuilder builder) {
            Optional.ofNullable(this.getDateTime()).ifPresent(builder::setDateTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DateTimeList _that = this.getType().cast(o);
            return ListEquals.listEquals(this.dateTime, _that.getDateTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateTime != null ? this.dateTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DateTimeList {dateTime=" + this.dateTime + '}';
        }
    }
}

