/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.Frequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FrequencyPositivePeriodMultiplier")
@ImplementedBy(value=Default.class)
public interface FrequencyPositivePeriodMultiplier
extends Validator<Frequency> {
    public static final String NAME = "FrequencyPositivePeriodMultiplier";
    public static final String DEFINITION = "periodMultiplier > 0";

    public static class NoOp
    implements FrequencyPositivePeriodMultiplier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Frequency frequency) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FrequencyPositivePeriodMultiplier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Frequency frequency) {
            ComparisonResult result = this.executeDataRule(frequency);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FrequencyPositivePeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Frequency", (RosettaPath)path, (String)FrequencyPositivePeriodMultiplier.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FrequencyPositivePeriodMultiplier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Frequency", (RosettaPath)path, (String)FrequencyPositivePeriodMultiplier.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Frequency frequency) {
            try {
                return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)frequency).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

