/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.validation.datarule;

import cdm.base.math.NonNegativeStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NonNegativeStepStepValue")
@ImplementedBy(value=Default.class)
public interface NonNegativeStepStepValue
extends Validator<NonNegativeStep> {
    public static final String NAME = "NonNegativeStepStepValue";
    public static final String DEFINITION = "stepValue >= 0.0";

    public static class NoOp
    implements NonNegativeStepStepValue {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonNegativeStep nonNegativeStep) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NonNegativeStepStepValue {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonNegativeStep nonNegativeStep) {
            ComparisonResult result = this.executeDataRule(nonNegativeStep);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NonNegativeStepStepValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonNegativeStep", (RosettaPath)path, (String)NonNegativeStepStepValue.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NonNegativeStepStepValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonNegativeStep", (RosettaPath)path, (String)NonNegativeStepStepValue.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(NonNegativeStep nonNegativeStep) {
            try {
                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)nonNegativeStep).map("getStepValue", _nonNegativeStep -> _nonNegativeStep.getStepValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

