/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.BusinessUnit;
import cdm.base.staticdata.party.ContactInformation;
import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.meta.PartyMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Party", builder=PartyBuilderImpl.class, version="5.27.0")
@RuneDataType(value="Party", model="cdm", builder=PartyBuilderImpl.class, version="5.27.0")
public interface Party
extends RosettaModelObject,
GlobalKey {
    public static final PartyMeta metaData = new PartyMeta();

    public List<? extends PartyIdentifier> getPartyId();

    public FieldWithMetaString getName();

    public List<? extends BusinessUnit> getBusinessUnit();

    public List<? extends NaturalPerson> getPerson();

    public List<? extends NaturalPersonRole> getPersonRole();

    public Account getAccount();

    public ContactInformation getContactInformation();

    public MetaFields getMeta();

    public Party build();

    public PartyBuilder toBuilder();

    public static PartyBuilder builder() {
        return new PartyBuilderImpl();
    }

    default public RosettaMetaData<? extends Party> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Party> getType() {
        return Party.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyId"), processor, PartyIdentifier.class, this.getPartyId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.class, this.getBusinessUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("person"), processor, NaturalPerson.class, this.getPerson(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("personRole"), processor, NaturalPersonRole.class, this.getPersonRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("account"), processor, Account.class, this.getAccount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.class, this.getContactInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PartyBuilderImpl
    implements PartyBuilder {
        protected List<PartyIdentifier.PartyIdentifierBuilder> partyId = new ArrayList<PartyIdentifier.PartyIdentifierBuilder>();
        protected FieldWithMetaString.FieldWithMetaStringBuilder name;
        protected List<BusinessUnit.BusinessUnitBuilder> businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
        protected List<NaturalPerson.NaturalPersonBuilder> person = new ArrayList<NaturalPerson.NaturalPersonBuilder>();
        protected List<NaturalPersonRole.NaturalPersonRoleBuilder> personRole = new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>();
        protected Account.AccountBuilder account;
        protected ContactInformation.ContactInformationBuilder contactInformation;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="partyId", isRequired=true)
        @RuneAttribute(value="partyId", isRequired=true)
        public List<? extends PartyIdentifier.PartyIdentifierBuilder> getPartyId() {
            return this.partyId;
        }

        @Override
        public PartyIdentifier.PartyIdentifierBuilder getOrCreatePartyId(int index) {
            if (this.partyId == null) {
                this.partyId = new ArrayList<PartyIdentifier.PartyIdentifierBuilder>();
            }
            return (PartyIdentifier.PartyIdentifierBuilder)this.getIndex(this.partyId, index, () -> {
                PartyIdentifier.PartyIdentifierBuilder newPartyId = PartyIdentifier.builder();
                return newPartyId;
            });
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FieldWithMetaString.FieldWithMetaStringBuilder getName() {
            return this.name;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateName() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.name != null ? this.name : (this.name = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int index) {
            if (this.businessUnit == null) {
                this.businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
            }
            return (BusinessUnit.BusinessUnitBuilder)this.getIndex(this.businessUnit, index, () -> {
                BusinessUnit.BusinessUnitBuilder newBusinessUnit = BusinessUnit.builder();
                return newBusinessUnit;
            });
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public List<? extends NaturalPerson.NaturalPersonBuilder> getPerson() {
            return this.person;
        }

        @Override
        public NaturalPerson.NaturalPersonBuilder getOrCreatePerson(int index) {
            if (this.person == null) {
                this.person = new ArrayList<NaturalPerson.NaturalPersonBuilder>();
            }
            return (NaturalPerson.NaturalPersonBuilder)this.getIndex(this.person, index, () -> {
                NaturalPerson.NaturalPersonBuilder newPerson = NaturalPerson.builder();
                return newPerson;
            });
        }

        @Override
        @RosettaAttribute(value="personRole")
        @RuneAttribute(value="personRole")
        public List<? extends NaturalPersonRole.NaturalPersonRoleBuilder> getPersonRole() {
            return this.personRole;
        }

        @Override
        public NaturalPersonRole.NaturalPersonRoleBuilder getOrCreatePersonRole(int index) {
            if (this.personRole == null) {
                this.personRole = new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>();
            }
            return (NaturalPersonRole.NaturalPersonRoleBuilder)this.getIndex(this.personRole, index, () -> {
                NaturalPersonRole.NaturalPersonRoleBuilder newPersonRole = NaturalPersonRole.builder();
                return newPersonRole;
            });
        }

        @Override
        @RosettaAttribute(value="account")
        @RuneAttribute(value="account")
        public Account.AccountBuilder getAccount() {
            return this.account;
        }

        @Override
        public Account.AccountBuilder getOrCreateAccount() {
            Account.AccountBuilder result = this.account != null ? this.account : (this.account = Account.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contactInformation")
        @RuneAttribute(value="contactInformation")
        public ContactInformation.ContactInformationBuilder getContactInformation() {
            return this.contactInformation;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation() {
            ContactInformation.ContactInformationBuilder result = this.contactInformation != null ? this.contactInformation : (this.contactInformation = ContactInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyId", isRequired=true)
        @RuneAttribute(value="partyId", isRequired=true)
        public PartyBuilder addPartyId(PartyIdentifier _partyId) {
            if (_partyId != null) {
                this.partyId.add(_partyId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyBuilder addPartyId(PartyIdentifier _partyId, int idx) {
            this.getIndex(this.partyId, idx, () -> _partyId.toBuilder());
            return this;
        }

        @Override
        public PartyBuilder addPartyId(List<? extends PartyIdentifier> partyIds) {
            if (partyIds != null) {
                for (PartyIdentifier partyIdentifier : partyIds) {
                    this.partyId.add(partyIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyId")
        public PartyBuilder setPartyId(List<? extends PartyIdentifier> partyIds) {
            this.partyId = partyIds == null ? new ArrayList<PartyIdentifier.PartyIdentifierBuilder>() : (List)partyIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public PartyBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public PartyBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public PartyBuilder addBusinessUnit(BusinessUnit _businessUnit) {
            if (_businessUnit != null) {
                this.businessUnit.add(_businessUnit.toBuilder());
            }
            return this;
        }

        @Override
        public PartyBuilder addBusinessUnit(BusinessUnit _businessUnit, int idx) {
            this.getIndex(this.businessUnit, idx, () -> _businessUnit.toBuilder());
            return this;
        }

        @Override
        public PartyBuilder addBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            if (businessUnits != null) {
                for (BusinessUnit businessUnit : businessUnits) {
                    this.businessUnit.add(businessUnit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="businessUnit")
        public PartyBuilder setBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            this.businessUnit = businessUnits == null ? new ArrayList<BusinessUnit.BusinessUnitBuilder>() : (List)businessUnits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public PartyBuilder addPerson(NaturalPerson _person) {
            if (_person != null) {
                this.person.add(_person.toBuilder());
            }
            return this;
        }

        @Override
        public PartyBuilder addPerson(NaturalPerson _person, int idx) {
            this.getIndex(this.person, idx, () -> _person.toBuilder());
            return this;
        }

        @Override
        public PartyBuilder addPerson(List<? extends NaturalPerson> persons) {
            if (persons != null) {
                for (NaturalPerson naturalPerson : persons) {
                    this.person.add(naturalPerson.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="person")
        public PartyBuilder setPerson(List<? extends NaturalPerson> persons) {
            this.person = persons == null ? new ArrayList<NaturalPerson.NaturalPersonBuilder>() : (List)persons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="personRole")
        @RuneAttribute(value="personRole")
        public PartyBuilder addPersonRole(NaturalPersonRole _personRole) {
            if (_personRole != null) {
                this.personRole.add(_personRole.toBuilder());
            }
            return this;
        }

        @Override
        public PartyBuilder addPersonRole(NaturalPersonRole _personRole, int idx) {
            this.getIndex(this.personRole, idx, () -> _personRole.toBuilder());
            return this;
        }

        @Override
        public PartyBuilder addPersonRole(List<? extends NaturalPersonRole> personRoles) {
            if (personRoles != null) {
                for (NaturalPersonRole naturalPersonRole : personRoles) {
                    this.personRole.add(naturalPersonRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="personRole")
        public PartyBuilder setPersonRole(List<? extends NaturalPersonRole> personRoles) {
            this.personRole = personRoles == null ? new ArrayList<NaturalPersonRole.NaturalPersonRoleBuilder>() : (List)personRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="account")
        @RuneAttribute(value="account")
        public PartyBuilder setAccount(Account _account) {
            this.account = _account == null ? null : _account.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contactInformation")
        @RuneAttribute(value="contactInformation")
        public PartyBuilder setContactInformation(ContactInformation _contactInformation) {
            this.contactInformation = _contactInformation == null ? null : _contactInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PartyBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Party build() {
            return new PartyImpl(this);
        }

        @Override
        public PartyBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyBuilder prune() {
            this.partyId = this.partyId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.name != null && !this.name.prune().hasData()) {
                this.name = null;
            }
            this.businessUnit = this.businessUnit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.person = this.person.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.personRole = this.personRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.account != null && !this.account.prune().hasData()) {
                this.account = null;
            }
            if (this.contactInformation != null && !this.contactInformation.prune().hasData()) {
                this.contactInformation = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPartyId() != null && this.getPartyId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getName() != null) {
                return true;
            }
            if (this.getBusinessUnit() != null && this.getBusinessUnit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPerson() != null && this.getPerson().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPersonRole() != null && this.getPersonRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAccount() != null && this.getAccount().hasData()) {
                return true;
            }
            return this.getContactInformation() != null && this.getContactInformation().hasData();
        }

        public PartyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyBuilder o = (PartyBuilder)other;
            merger.mergeRosetta(this.getPartyId(), o.getPartyId(), this::getOrCreatePartyId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getName(), (RosettaModelObjectBuilder)o.getName(), this::setName);
            merger.mergeRosetta(this.getBusinessUnit(), o.getBusinessUnit(), this::getOrCreateBusinessUnit);
            merger.mergeRosetta(this.getPerson(), o.getPerson(), this::getOrCreatePerson);
            merger.mergeRosetta(this.getPersonRole(), o.getPersonRole(), this::getOrCreatePersonRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccount(), (RosettaModelObjectBuilder)o.getAccount(), this::setAccount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInformation(), (RosettaModelObjectBuilder)o.getContactInformation(), this::setContactInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Party _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.partyId, _that.getPartyId())) {
                return false;
            }
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            if (!ListEquals.listEquals(this.person, _that.getPerson())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personRole, _that.getPersonRole())) {
                return false;
            }
            if (!Objects.equals(this.account, _that.getAccount())) {
                return false;
            }
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyId != null ? this.partyId.hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            _result = 31 * _result + (this.personRole != null ? this.personRole.hashCode() : 0);
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyBuilder {partyId=" + this.partyId + ", name=" + this.name + ", businessUnit=" + this.businessUnit + ", person=" + this.person + ", personRole=" + this.personRole + ", account=" + this.account + ", contactInformation=" + this.contactInformation + ", meta=" + this.meta + '}';
        }
    }

    public static interface PartyBuilder
    extends Party,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public PartyIdentifier.PartyIdentifierBuilder getOrCreatePartyId(int var1);

        public List<? extends PartyIdentifier.PartyIdentifierBuilder> getPartyId();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateName();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getName();

        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int var1);

        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit();

        public NaturalPerson.NaturalPersonBuilder getOrCreatePerson(int var1);

        public List<? extends NaturalPerson.NaturalPersonBuilder> getPerson();

        public NaturalPersonRole.NaturalPersonRoleBuilder getOrCreatePersonRole(int var1);

        public List<? extends NaturalPersonRole.NaturalPersonRoleBuilder> getPersonRole();

        public Account.AccountBuilder getOrCreateAccount();

        @Override
        public Account.AccountBuilder getAccount();

        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInformation();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PartyBuilder addPartyId(PartyIdentifier var1);

        public PartyBuilder addPartyId(PartyIdentifier var1, int var2);

        public PartyBuilder addPartyId(List<? extends PartyIdentifier> var1);

        public PartyBuilder setPartyId(List<? extends PartyIdentifier> var1);

        public PartyBuilder setName(FieldWithMetaString var1);

        public PartyBuilder setNameValue(String var1);

        public PartyBuilder addBusinessUnit(BusinessUnit var1);

        public PartyBuilder addBusinessUnit(BusinessUnit var1, int var2);

        public PartyBuilder addBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyBuilder setBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyBuilder addPerson(NaturalPerson var1);

        public PartyBuilder addPerson(NaturalPerson var1, int var2);

        public PartyBuilder addPerson(List<? extends NaturalPerson> var1);

        public PartyBuilder setPerson(List<? extends NaturalPerson> var1);

        public PartyBuilder addPersonRole(NaturalPersonRole var1);

        public PartyBuilder addPersonRole(NaturalPersonRole var1, int var2);

        public PartyBuilder addPersonRole(List<? extends NaturalPersonRole> var1);

        public PartyBuilder setPersonRole(List<? extends NaturalPersonRole> var1);

        public PartyBuilder setAccount(Account var1);

        public PartyBuilder setContactInformation(ContactInformation var1);

        public PartyBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyId"), processor, PartyIdentifier.PartyIdentifierBuilder.class, this.getPartyId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.BusinessUnitBuilder.class, this.getBusinessUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("person"), processor, NaturalPerson.NaturalPersonBuilder.class, this.getPerson(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("personRole"), processor, NaturalPersonRole.NaturalPersonRoleBuilder.class, this.getPersonRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("account"), processor, Account.AccountBuilder.class, this.getAccount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PartyBuilder prune();
    }

    public static class PartyImpl
    implements Party {
        private final List<? extends PartyIdentifier> partyId;
        private final FieldWithMetaString name;
        private final List<? extends BusinessUnit> businessUnit;
        private final List<? extends NaturalPerson> person;
        private final List<? extends NaturalPersonRole> personRole;
        private final Account account;
        private final ContactInformation contactInformation;
        private final MetaFields meta;

        protected PartyImpl(PartyBuilder builder) {
            this.partyId = Optional.ofNullable(builder.getPartyId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.name = Optional.ofNullable(builder.getName()).map(f -> f.build()).orElse(null);
            this.businessUnit = Optional.ofNullable(builder.getBusinessUnit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.person = Optional.ofNullable(builder.getPerson()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.personRole = Optional.ofNullable(builder.getPersonRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.account = Optional.ofNullable(builder.getAccount()).map(f -> f.build()).orElse(null);
            this.contactInformation = Optional.ofNullable(builder.getContactInformation()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyId", isRequired=true)
        @RuneAttribute(value="partyId", isRequired=true)
        public List<? extends PartyIdentifier> getPartyId() {
            return this.partyId;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FieldWithMetaString getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public List<? extends BusinessUnit> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public List<? extends NaturalPerson> getPerson() {
            return this.person;
        }

        @Override
        @RosettaAttribute(value="personRole")
        @RuneAttribute(value="personRole")
        public List<? extends NaturalPersonRole> getPersonRole() {
            return this.personRole;
        }

        @Override
        @RosettaAttribute(value="account")
        @RuneAttribute(value="account")
        public Account getAccount() {
            return this.account;
        }

        @Override
        @RosettaAttribute(value="contactInformation")
        @RuneAttribute(value="contactInformation")
        public ContactInformation getContactInformation() {
            return this.contactInformation;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Party build() {
            return this;
        }

        @Override
        public PartyBuilder toBuilder() {
            PartyBuilder builder = Party.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyBuilder builder) {
            Optional.ofNullable(this.getPartyId()).ifPresent(builder::setPartyId);
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getBusinessUnit()).ifPresent(builder::setBusinessUnit);
            Optional.ofNullable(this.getPerson()).ifPresent(builder::setPerson);
            Optional.ofNullable(this.getPersonRole()).ifPresent(builder::setPersonRole);
            Optional.ofNullable(this.getAccount()).ifPresent(builder::setAccount);
            Optional.ofNullable(this.getContactInformation()).ifPresent(builder::setContactInformation);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Party _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.partyId, _that.getPartyId())) {
                return false;
            }
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            if (!ListEquals.listEquals(this.person, _that.getPerson())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personRole, _that.getPersonRole())) {
                return false;
            }
            if (!Objects.equals(this.account, _that.getAccount())) {
                return false;
            }
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyId != null ? this.partyId.hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            _result = 31 * _result + (this.personRole != null ? this.personRole.hashCode() : 0);
            _result = 31 * _result + (this.account != null ? this.account.hashCode() : 0);
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Party {partyId=" + this.partyId + ", name=" + this.name + ", businessUnit=" + this.businessUnit + ", person=" + this.person + ", personRole=" + this.personRole + ", account=" + this.account + ", contactInformation=" + this.contactInformation + ", meta=" + this.meta + '}';
        }
    }
}

