/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.BusinessUnit;
import cdm.base.staticdata.party.ContactInformation;
import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.meta.PartyContactInformationMeta;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyContactInformation", builder=PartyContactInformationBuilderImpl.class, version="5.27.0")
@RuneDataType(value="PartyContactInformation", model="cdm", builder=PartyContactInformationBuilderImpl.class, version="5.27.0")
public interface PartyContactInformation
extends RosettaModelObject {
    public static final PartyContactInformationMeta metaData = new PartyContactInformationMeta();

    public ReferenceWithMetaParty getPartyReference();

    public ContactInformation getContactInformation();

    public List<? extends BusinessUnit> getBusinessUnit();

    public List<? extends NaturalPerson> getPerson();

    public String getAdditionalInformation();

    public PartyContactInformation build();

    public PartyContactInformationBuilder toBuilder();

    public static PartyContactInformationBuilder builder() {
        return new PartyContactInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyContactInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyContactInformation> getType() {
        return PartyContactInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.class, this.getContactInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.class, this.getBusinessUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("person"), processor, NaturalPerson.class, this.getPerson(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalInformation"), String.class, (Object)this.getAdditionalInformation(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PartyContactInformationBuilderImpl
    implements PartyContactInformationBuilder {
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference;
        protected ContactInformation.ContactInformationBuilder contactInformation;
        protected List<BusinessUnit.BusinessUnitBuilder> businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
        protected List<NaturalPerson.NaturalPersonBuilder> person = new ArrayList<NaturalPerson.NaturalPersonBuilder>();
        protected String additionalInformation;

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contactInformation")
        @RuneAttribute(value="contactInformation")
        public ContactInformation.ContactInformationBuilder getContactInformation() {
            return this.contactInformation;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation() {
            ContactInformation.ContactInformationBuilder result = this.contactInformation != null ? this.contactInformation : (this.contactInformation = ContactInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int index) {
            if (this.businessUnit == null) {
                this.businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
            }
            return (BusinessUnit.BusinessUnitBuilder)this.getIndex(this.businessUnit, index, () -> {
                BusinessUnit.BusinessUnitBuilder newBusinessUnit = BusinessUnit.builder();
                return newBusinessUnit;
            });
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public List<? extends NaturalPerson.NaturalPersonBuilder> getPerson() {
            return this.person;
        }

        @Override
        public NaturalPerson.NaturalPersonBuilder getOrCreatePerson(int index) {
            if (this.person == null) {
                this.person = new ArrayList<NaturalPerson.NaturalPersonBuilder>();
            }
            return (NaturalPerson.NaturalPersonBuilder)this.getIndex(this.person, index, () -> {
                NaturalPerson.NaturalPersonBuilder newPerson = NaturalPerson.builder();
                return newPerson;
            });
        }

        @Override
        @RosettaAttribute(value="additionalInformation")
        @RuneAttribute(value="additionalInformation")
        public String getAdditionalInformation() {
            return this.additionalInformation;
        }

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public PartyContactInformationBuilder setPartyReference(ReferenceWithMetaParty _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        public PartyContactInformationBuilder setPartyReferenceValue(Party _partyReference) {
            this.getOrCreatePartyReference().setValue(_partyReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="contactInformation")
        @RuneAttribute(value="contactInformation")
        public PartyContactInformationBuilder setContactInformation(ContactInformation _contactInformation) {
            this.contactInformation = _contactInformation == null ? null : _contactInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit _businessUnit) {
            if (_businessUnit != null) {
                this.businessUnit.add(_businessUnit.toBuilder());
            }
            return this;
        }

        @Override
        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit _businessUnit, int idx) {
            this.getIndex(this.businessUnit, idx, () -> _businessUnit.toBuilder());
            return this;
        }

        @Override
        public PartyContactInformationBuilder addBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            if (businessUnits != null) {
                for (BusinessUnit businessUnit : businessUnits) {
                    this.businessUnit.add(businessUnit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="businessUnit")
        public PartyContactInformationBuilder setBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            this.businessUnit = businessUnits == null ? new ArrayList<BusinessUnit.BusinessUnitBuilder>() : (List)businessUnits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public PartyContactInformationBuilder addPerson(NaturalPerson _person) {
            if (_person != null) {
                this.person.add(_person.toBuilder());
            }
            return this;
        }

        @Override
        public PartyContactInformationBuilder addPerson(NaturalPerson _person, int idx) {
            this.getIndex(this.person, idx, () -> _person.toBuilder());
            return this;
        }

        @Override
        public PartyContactInformationBuilder addPerson(List<? extends NaturalPerson> persons) {
            if (persons != null) {
                for (NaturalPerson naturalPerson : persons) {
                    this.person.add(naturalPerson.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="person")
        public PartyContactInformationBuilder setPerson(List<? extends NaturalPerson> persons) {
            this.person = persons == null ? new ArrayList<NaturalPerson.NaturalPersonBuilder>() : (List)persons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalInformation")
        @RuneAttribute(value="additionalInformation")
        public PartyContactInformationBuilder setAdditionalInformation(String _additionalInformation) {
            this.additionalInformation = _additionalInformation == null ? null : _additionalInformation;
            return this;
        }

        @Override
        public PartyContactInformation build() {
            return new PartyContactInformationImpl(this);
        }

        @Override
        public PartyContactInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyContactInformationBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            if (this.contactInformation != null && !this.contactInformation.prune().hasData()) {
                this.contactInformation = null;
            }
            this.businessUnit = this.businessUnit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.person = this.person.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getContactInformation() != null && this.getContactInformation().hasData()) {
                return true;
            }
            if (this.getBusinessUnit() != null && this.getBusinessUnit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPerson() != null && this.getPerson().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAdditionalInformation() != null;
        }

        public PartyContactInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyContactInformationBuilder o = (PartyContactInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInformation(), (RosettaModelObjectBuilder)o.getContactInformation(), this::setContactInformation);
            merger.mergeRosetta(this.getBusinessUnit(), o.getBusinessUnit(), this::getOrCreateBusinessUnit);
            merger.mergeRosetta(this.getPerson(), o.getPerson(), this::getOrCreatePerson);
            merger.mergeBasic((Object)this.getAdditionalInformation(), (Object)o.getAdditionalInformation(), this::setAdditionalInformation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyContactInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            if (!ListEquals.listEquals(this.person, _that.getPerson())) {
                return false;
            }
            return Objects.equals(this.additionalInformation, _that.getAdditionalInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            _result = 31 * _result + (this.additionalInformation != null ? this.additionalInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyContactInformationBuilder {partyReference=" + this.partyReference + ", contactInformation=" + this.contactInformation + ", businessUnit=" + this.businessUnit + ", person=" + this.person + ", additionalInformation=" + this.additionalInformation + '}';
        }
    }

    public static interface PartyContactInformationBuilder
    extends PartyContactInformation,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference();

        public ContactInformation.ContactInformationBuilder getOrCreateContactInformation();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInformation();

        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int var1);

        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit();

        public NaturalPerson.NaturalPersonBuilder getOrCreatePerson(int var1);

        public List<? extends NaturalPerson.NaturalPersonBuilder> getPerson();

        public PartyContactInformationBuilder setPartyReference(ReferenceWithMetaParty var1);

        public PartyContactInformationBuilder setPartyReferenceValue(Party var1);

        public PartyContactInformationBuilder setContactInformation(ContactInformation var1);

        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit var1);

        public PartyContactInformationBuilder addBusinessUnit(BusinessUnit var1, int var2);

        public PartyContactInformationBuilder addBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyContactInformationBuilder setBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyContactInformationBuilder addPerson(NaturalPerson var1);

        public PartyContactInformationBuilder addPerson(NaturalPerson var1, int var2);

        public PartyContactInformationBuilder addPerson(List<? extends NaturalPerson> var1);

        public PartyContactInformationBuilder setPerson(List<? extends NaturalPerson> var1);

        public PartyContactInformationBuilder setAdditionalInformation(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInformation"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.BusinessUnitBuilder.class, this.getBusinessUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("person"), processor, NaturalPerson.NaturalPersonBuilder.class, this.getPerson(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalInformation"), String.class, (Object)this.getAdditionalInformation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PartyContactInformationBuilder prune();
    }

    public static class PartyContactInformationImpl
    implements PartyContactInformation {
        private final ReferenceWithMetaParty partyReference;
        private final ContactInformation contactInformation;
        private final List<? extends BusinessUnit> businessUnit;
        private final List<? extends NaturalPerson> person;
        private final String additionalInformation;

        protected PartyContactInformationImpl(PartyContactInformationBuilder builder) {
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.contactInformation = Optional.ofNullable(builder.getContactInformation()).map(f -> f.build()).orElse(null);
            this.businessUnit = Optional.ofNullable(builder.getBusinessUnit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.person = Optional.ofNullable(builder.getPerson()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalInformation = builder.getAdditionalInformation();
        }

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public ReferenceWithMetaParty getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="contactInformation")
        @RuneAttribute(value="contactInformation")
        public ContactInformation getContactInformation() {
            return this.contactInformation;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public List<? extends BusinessUnit> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public List<? extends NaturalPerson> getPerson() {
            return this.person;
        }

        @Override
        @RosettaAttribute(value="additionalInformation")
        @RuneAttribute(value="additionalInformation")
        public String getAdditionalInformation() {
            return this.additionalInformation;
        }

        @Override
        public PartyContactInformation build() {
            return this;
        }

        @Override
        public PartyContactInformationBuilder toBuilder() {
            PartyContactInformationBuilder builder = PartyContactInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyContactInformationBuilder builder) {
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getContactInformation()).ifPresent(builder::setContactInformation);
            Optional.ofNullable(this.getBusinessUnit()).ifPresent(builder::setBusinessUnit);
            Optional.ofNullable(this.getPerson()).ifPresent(builder::setPerson);
            Optional.ofNullable(this.getAdditionalInformation()).ifPresent(builder::setAdditionalInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyContactInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.contactInformation, _that.getContactInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            if (!ListEquals.listEquals(this.person, _that.getPerson())) {
                return false;
            }
            return Objects.equals(this.additionalInformation, _that.getAdditionalInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.contactInformation != null ? this.contactInformation.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            _result = 31 * _result + (this.additionalInformation != null ? this.additionalInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyContactInformation {partyReference=" + this.partyReference + ", contactInformation=" + this.contactInformation + ", businessUnit=" + this.businessUnit + ", person=" + this.person + ", additionalInformation=" + this.additionalInformation + '}';
        }
    }
}

