/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.TimeZone;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.event.common.Trade;
import cdm.event.common.meta.TradePricingReportMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TradePricingReport", builder=TradePricingReportBuilderImpl.class, version="5.27.0")
@RuneDataType(value="TradePricingReport", model="cdm", builder=TradePricingReportBuilderImpl.class, version="5.27.0")
public interface TradePricingReport
extends RosettaModelObject {
    public static final TradePricingReportMeta metaData = new TradePricingReportMeta();

    public Trade getTrade();

    public TimeZone getPricingTime();

    public FloatingRateIndexEnum getDiscountingIndex();

    public TradePricingReport build();

    public TradePricingReportBuilder toBuilder();

    public static TradePricingReportBuilder builder() {
        return new TradePricingReportBuilderImpl();
    }

    default public RosettaMetaData<? extends TradePricingReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradePricingReport> getType() {
        return TradePricingReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingTime"), processor, TimeZone.class, this.getPricingTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discountingIndex"), FloatingRateIndexEnum.class, (Object)this.getDiscountingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TradePricingReportBuilderImpl
    implements TradePricingReportBuilder {
        protected Trade.TradeBuilder trade;
        protected TimeZone.TimeZoneBuilder pricingTime;
        protected FloatingRateIndexEnum discountingIndex;

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingTime", isRequired=true)
        @RuneAttribute(value="pricingTime", isRequired=true)
        public TimeZone.TimeZoneBuilder getPricingTime() {
            return this.pricingTime;
        }

        @Override
        public TimeZone.TimeZoneBuilder getOrCreatePricingTime() {
            TimeZone.TimeZoneBuilder result = this.pricingTime != null ? this.pricingTime : (this.pricingTime = TimeZone.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountingIndex")
        @RuneAttribute(value="discountingIndex")
        public FloatingRateIndexEnum getDiscountingIndex() {
            return this.discountingIndex;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public TradePricingReportBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingTime", isRequired=true)
        @RuneAttribute(value="pricingTime", isRequired=true)
        public TradePricingReportBuilder setPricingTime(TimeZone _pricingTime) {
            this.pricingTime = _pricingTime == null ? null : _pricingTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="discountingIndex")
        @RuneAttribute(value="discountingIndex")
        public TradePricingReportBuilder setDiscountingIndex(FloatingRateIndexEnum _discountingIndex) {
            this.discountingIndex = _discountingIndex == null ? null : _discountingIndex;
            return this;
        }

        @Override
        public TradePricingReport build() {
            return new TradePricingReportImpl(this);
        }

        @Override
        public TradePricingReportBuilder toBuilder() {
            return this;
        }

        @Override
        public TradePricingReportBuilder prune() {
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            if (this.pricingTime != null && !this.pricingTime.prune().hasData()) {
                this.pricingTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            if (this.getPricingTime() != null && this.getPricingTime().hasData()) {
                return true;
            }
            return this.getDiscountingIndex() != null;
        }

        public TradePricingReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradePricingReportBuilder o = (TradePricingReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingTime(), (RosettaModelObjectBuilder)o.getPricingTime(), this::setPricingTime);
            merger.mergeBasic((Object)this.getDiscountingIndex(), (Object)o.getDiscountingIndex(), this::setDiscountingIndex, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradePricingReport _that = this.getType().cast(o);
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.pricingTime, _that.getPricingTime())) {
                return false;
            }
            return Objects.equals((Object)this.discountingIndex, (Object)_that.getDiscountingIndex());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.pricingTime != null ? this.pricingTime.hashCode() : 0);
            _result = 31 * _result + (this.discountingIndex != null ? ((Object)((Object)this.discountingIndex)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradePricingReportBuilder {trade=" + this.trade + ", pricingTime=" + this.pricingTime + ", discountingIndex=" + (Object)((Object)this.discountingIndex) + '}';
        }
    }

    public static interface TradePricingReportBuilder
    extends TradePricingReport,
    RosettaModelObjectBuilder {
        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public TimeZone.TimeZoneBuilder getOrCreatePricingTime();

        @Override
        public TimeZone.TimeZoneBuilder getPricingTime();

        public TradePricingReportBuilder setTrade(Trade var1);

        public TradePricingReportBuilder setPricingTime(TimeZone var1);

        public TradePricingReportBuilder setDiscountingIndex(FloatingRateIndexEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingTime"), processor, TimeZone.TimeZoneBuilder.class, this.getPricingTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discountingIndex"), FloatingRateIndexEnum.class, (Object)this.getDiscountingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TradePricingReportBuilder prune();
    }

    public static class TradePricingReportImpl
    implements TradePricingReport {
        private final Trade trade;
        private final TimeZone pricingTime;
        private final FloatingRateIndexEnum discountingIndex;

        protected TradePricingReportImpl(TradePricingReportBuilder builder) {
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.pricingTime = Optional.ofNullable(builder.getPricingTime()).map(f -> f.build()).orElse(null);
            this.discountingIndex = builder.getDiscountingIndex();
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="pricingTime", isRequired=true)
        @RuneAttribute(value="pricingTime", isRequired=true)
        public TimeZone getPricingTime() {
            return this.pricingTime;
        }

        @Override
        @RosettaAttribute(value="discountingIndex")
        @RuneAttribute(value="discountingIndex")
        public FloatingRateIndexEnum getDiscountingIndex() {
            return this.discountingIndex;
        }

        @Override
        public TradePricingReport build() {
            return this;
        }

        @Override
        public TradePricingReportBuilder toBuilder() {
            TradePricingReportBuilder builder = TradePricingReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradePricingReportBuilder builder) {
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getPricingTime()).ifPresent(builder::setPricingTime);
            Optional.ofNullable(this.getDiscountingIndex()).ifPresent(builder::setDiscountingIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradePricingReport _that = this.getType().cast(o);
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.pricingTime, _that.getPricingTime())) {
                return false;
            }
            return Objects.equals((Object)this.discountingIndex, (Object)_that.getDiscountingIndex());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.pricingTime != null ? this.pricingTime.hashCode() : 0);
            _result = 31 * _result + (this.discountingIndex != null ? ((Object)((Object)this.discountingIndex)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradePricingReport {trade=" + this.trade + ", pricingTime=" + this.pricingTime + ", discountingIndex=" + (Object)((Object)this.discountingIndex) + '}';
        }
    }
}

