/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.identifier.metafields.FieldWithMetaIdentifier;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.event.common.meta.TransferBaseMeta;
import cdm.observable.asset.Observable;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TransferBase", builder=TransferBaseBuilderImpl.class, version="5.27.0")
@RuneDataType(value="TransferBase", model="cdm", builder=TransferBaseBuilderImpl.class, version="5.27.0")
public interface TransferBase
extends RosettaModelObject {
    public static final TransferBaseMeta metaData = new TransferBaseMeta();

    public List<? extends FieldWithMetaIdentifier> getIdentifier();

    public NonNegativeQuantity getQuantity();

    public Observable getObservable();

    public PartyReferencePayerReceiver getPayerReceiver();

    public AdjustableOrAdjustedOrRelativeDate getSettlementDate();

    public TransferBase build();

    public TransferBaseBuilder toBuilder();

    public static TransferBaseBuilder builder() {
        return new TransferBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends TransferBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TransferBase> getType() {
        return TransferBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, FieldWithMetaIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observable"), processor, Observable.class, this.getObservable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
    }

    public static class TransferBaseBuilderImpl
    implements TransferBaseBuilder {
        protected List<FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder> identifier = new ArrayList<FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder>();
        protected NonNegativeQuantity.NonNegativeQuantityBuilder quantity;
        protected Observable.ObservableBuilder observable;
        protected PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder payerReceiver;
        protected AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder settlementDate;

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public List<? extends FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder> getIdentifier() {
            return this.identifier;
        }

        @Override
        public FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder getOrCreateIdentifier(int index) {
            if (this.identifier == null) {
                this.identifier = new ArrayList<FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder>();
            }
            return (FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder)this.getIndex(this.identifier, index, () -> {
                FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder newIdentifier = FieldWithMetaIdentifier.builder();
                return newIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public NonNegativeQuantity.NonNegativeQuantityBuilder getQuantity() {
            return this.quantity;
        }

        @Override
        public NonNegativeQuantity.NonNegativeQuantityBuilder getOrCreateQuantity() {
            NonNegativeQuantity.NonNegativeQuantityBuilder result = this.quantity != null ? this.quantity : (this.quantity = NonNegativeQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public Observable.ObservableBuilder getObservable() {
            return this.observable;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateObservable() {
            Observable.ObservableBuilder result = this.observable != null ? this.observable : (this.observable = Observable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getOrCreatePayerReceiver() {
            PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PartyReferencePayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getOrCreateSettlementDate() {
            AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrAdjustedOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public TransferBaseBuilder addIdentifier(FieldWithMetaIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public TransferBaseBuilder addIdentifier(FieldWithMetaIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBaseBuilder addIdentifierValue(Identifier _identifier) {
            this.getOrCreateIdentifier(-1).setValue(_identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBaseBuilder addIdentifierValue(Identifier _identifier, int idx) {
            this.getOrCreateIdentifier(idx).setValue(_identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBaseBuilder addIdentifier(List<? extends FieldWithMetaIdentifier> identifiers) {
            if (identifiers != null) {
                for (FieldWithMetaIdentifier fieldWithMetaIdentifier : identifiers) {
                    this.identifier.add(fieldWithMetaIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public TransferBaseBuilder setIdentifier(List<? extends FieldWithMetaIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList<FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder>() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TransferBaseBuilder addIdentifierValue(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.addIdentifierValue(identifier);
                }
            }
            return this;
        }

        @Override
        public TransferBaseBuilder setIdentifierValue(List<? extends Identifier> identifiers) {
            this.identifier.clear();
            if (identifiers != null) {
                identifiers.forEach(this::addIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public TransferBaseBuilder setQuantity(NonNegativeQuantity _quantity) {
            this.quantity = _quantity == null ? null : _quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public TransferBaseBuilder setObservable(Observable _observable) {
            this.observable = _observable == null ? null : _observable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public TransferBaseBuilder setPayerReceiver(PartyReferencePayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public TransferBaseBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        public TransferBase build() {
            return new TransferBaseImpl(this);
        }

        @Override
        public TransferBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public TransferBaseBuilder prune() {
            this.identifier = this.identifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.quantity != null && !this.quantity.prune().hasData()) {
                this.quantity = null;
            }
            if (this.observable != null && !this.observable.prune().hasData()) {
                this.observable = null;
            }
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null && this.getIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().hasData()) {
                return true;
            }
            if (this.getObservable() != null && this.getObservable().hasData()) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            return this.getSettlementDate() != null && this.getSettlementDate().hasData();
        }

        public TransferBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransferBaseBuilder o = (TransferBaseBuilder)other;
            merger.mergeRosetta(this.getIdentifier(), o.getIdentifier(), this::getOrCreateIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuantity(), (RosettaModelObjectBuilder)o.getQuantity(), this::setQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservable(), (RosettaModelObjectBuilder)o.getObservable(), this::setObservable);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransferBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransferBaseBuilder {identifier=" + this.identifier + ", quantity=" + this.quantity + ", observable=" + this.observable + ", payerReceiver=" + this.payerReceiver + ", settlementDate=" + this.settlementDate + '}';
        }
    }

    public static interface TransferBaseBuilder
    extends TransferBase,
    RosettaModelObjectBuilder {
        public FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder getOrCreateIdentifier(int var1);

        public List<? extends FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder> getIdentifier();

        public NonNegativeQuantity.NonNegativeQuantityBuilder getOrCreateQuantity();

        @Override
        public NonNegativeQuantity.NonNegativeQuantityBuilder getQuantity();

        public Observable.ObservableBuilder getOrCreateObservable();

        @Override
        public Observable.ObservableBuilder getObservable();

        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getPayerReceiver();

        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getSettlementDate();

        public TransferBaseBuilder addIdentifier(FieldWithMetaIdentifier var1);

        public TransferBaseBuilder addIdentifier(FieldWithMetaIdentifier var1, int var2);

        public TransferBaseBuilder addIdentifierValue(Identifier var1);

        public TransferBaseBuilder addIdentifierValue(Identifier var1, int var2);

        public TransferBaseBuilder addIdentifier(List<? extends FieldWithMetaIdentifier> var1);

        public TransferBaseBuilder setIdentifier(List<? extends FieldWithMetaIdentifier> var1);

        public TransferBaseBuilder addIdentifierValue(List<? extends Identifier> var1);

        public TransferBaseBuilder setIdentifierValue(List<? extends Identifier> var1);

        public TransferBaseBuilder setQuantity(NonNegativeQuantity var1);

        public TransferBaseBuilder setObservable(Observable var1);

        public TransferBaseBuilder setPayerReceiver(PartyReferencePayerReceiver var1);

        public TransferBaseBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.NonNegativeQuantityBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observable"), processor, Observable.ObservableBuilder.class, this.getObservable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
        }

        public TransferBaseBuilder prune();
    }

    public static class TransferBaseImpl
    implements TransferBase {
        private final List<? extends FieldWithMetaIdentifier> identifier;
        private final NonNegativeQuantity quantity;
        private final Observable observable;
        private final PartyReferencePayerReceiver payerReceiver;
        private final AdjustableOrAdjustedOrRelativeDate settlementDate;

        protected TransferBaseImpl(TransferBaseBuilder builder) {
            this.identifier = Optional.ofNullable(builder.getIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).map(f -> f.build()).orElse(null);
            this.observable = Optional.ofNullable(builder.getObservable()).map(f -> f.build()).orElse(null);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public List<? extends FieldWithMetaIdentifier> getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public NonNegativeQuantity getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public Observable getObservable() {
            return this.observable;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PartyReferencePayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrAdjustedOrRelativeDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public TransferBase build() {
            return this;
        }

        @Override
        public TransferBaseBuilder toBuilder() {
            TransferBaseBuilder builder = TransferBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransferBaseBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getObservable()).ifPresent(builder::setObservable);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransferBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransferBase {identifier=" + this.identifier + ", quantity=" + this.quantity + ", observable=" + this.observable + ", payerReceiver=" + this.payerReceiver + ", settlementDate=" + this.settlementDate + '}';
        }
    }
}

