/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.processor;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.QuantitySchedule;
import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.PartyChangeInstruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.SplitInstruction;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.Transfer;
import cdm.event.common.TransferInstruction;
import cdm.event.common.TransferState;
import cdm.legaldocumentation.contract.processor.PartyMappingHelper;
import cdm.observable.asset.FeeTypeEnum;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NovationInstructionMappingProcessor
extends MappingProcessor {
    private final SynonymToEnumMap synonymToEnumMap;

    public NovationInstructionMappingProcessor(RosettaPath rosettaPath, List<Path> synonymPaths, MappingContext context) {
        super(rosettaPath, synonymPaths, context);
        this.synonymToEnumMap = context.getSynonymToEnumMap();
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        PrimitiveInstruction.PrimitiveInstructionBuilder breakdown1Builder = PrimitiveInstruction.builder();
        this.getIncomingPartyChangeInstruction(synonymPath).ifPresent(breakdown1Builder::setPartyChange);
        this.getIncomingQuantityChangeInstruction(synonymPath).ifPresent(breakdown1Builder::setQuantityChange);
        this.getTransferInstruction(synonymPath).ifPresent(breakdown1Builder::setTransfer);
        PrimitiveInstruction.PrimitiveInstructionBuilder breakdown2Builder = PrimitiveInstruction.builder();
        this.getOutgoingQuantityChangeInstruction(synonymPath).ifPresent(breakdown2Builder::setQuantityChange);
        ArrayList<PrimitiveInstruction> breakdowns = new ArrayList<PrimitiveInstruction>();
        breakdowns.add(breakdown1Builder.build());
        breakdowns.add(breakdown2Builder.build());
        SplitInstruction.SplitInstructionBuilder splitInstructionBuilder = (SplitInstruction.SplitInstructionBuilder)parent;
        splitInstructionBuilder.setBreakdown(breakdowns);
    }

    private Optional<PartyChangeInstruction> getIncomingPartyChangeInstruction(Path synonymPath) {
        PartyChangeInstruction.PartyChangeInstructionBuilder partyChangeInstructionBuilder = PartyChangeInstruction.builder();
        Counterparty.CounterpartyBuilder counterpartyBuilder = partyChangeInstructionBuilder.getOrCreateCounterparty();
        PartyMappingHelper helper = PartyMappingHelper.getInstanceOrThrow(this.getContext());
        Path outgoingPartyPath = synonymPath.addElement("transferor");
        helper.setCounterpartyRoleEnum(this.getModelPath(), outgoingPartyPath, counterpartyBuilder::setRole);
        Path incomingPartyPath = synonymPath.addElement("transferee").addElement("href");
        this.setValueAndUpdateMappings(incomingPartyPath, xmlValue -> counterpartyBuilder.setPartyReference(ReferenceWithMetaParty.builder().setExternalReference((String)xmlValue)));
        TradeIdentifier.TradeIdentifierBuilder tradeIdBuilder = partyChangeInstructionBuilder.getOrCreateTradeId(0);
        AssignedIdentifier.AssignedIdentifierBuilder assignedIdentifierBuilder = tradeIdBuilder.getOrCreateAssignedIdentifier(0);
        Path newTradeIdentifierPath = synonymPath.addElement("newTradeIdentifier").addElement("versionedTradeId");
        Path tradeIdPath = newTradeIdentifierPath.addElement("tradeId");
        this.setValueAndUpdateMappings(tradeIdPath, assignedIdentifierBuilder.getOrCreateIdentifier()::setValue);
        this.setValueAndUpdateMappings(tradeIdPath.addElement("tradeIdScheme"), arg_0 -> ((MetaFields.MetaFieldsBuilder)assignedIdentifierBuilder.getOrCreateIdentifier().getOrCreateMeta()).setScheme(arg_0));
        this.setValueAndUpdateMappings(newTradeIdentifierPath.addElement("version"), xmlValue -> assignedIdentifierBuilder.setVersion(Integer.parseInt(xmlValue)));
        return partyChangeInstructionBuilder.prune().hasData() ? Optional.of(partyChangeInstructionBuilder.build()) : Optional.empty();
    }

    private Optional<QuantityChangeInstruction> getIncomingQuantityChangeInstruction(Path synonymPath) {
        QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstructionBuilder = QuantityChangeInstruction.builder();
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder novatedQuantityBuilder = quantityChangeInstructionBuilder.getOrCreateChange(0).getOrCreateQuantity(0).getOrCreateValue();
        this.setQuantity(novatedQuantityBuilder, synonymPath.addElement("novationAmount").addElement("changeInNotionalAmount"));
        this.setQuantity(novatedQuantityBuilder, synonymPath.addElement("novatedAmount"));
        return quantityChangeInstructionBuilder.prune().hasData() ? Optional.of(quantityChangeInstructionBuilder.setDirection(QuantityChangeDirectionEnum.REPLACE).build()) : Optional.empty();
    }

    private Optional<TransferInstruction> getTransferInstruction(Path synonymPath) {
        TransferInstruction.TransferInstructionBuilder transferInstructionBuilder = TransferInstruction.builder();
        TransferState.TransferStateBuilder tradeStateBuilder = transferInstructionBuilder.getOrCreateTransferState(0);
        Transfer.TransferBuilder transferBuilder = tradeStateBuilder.getOrCreateTransfer();
        Path paymentPath = synonymPath.addElement("payment");
        this.setValueAndUpdateMappings(paymentPath.addElement("id"), arg_0 -> ((MetaFields.MetaFieldsBuilder)tradeStateBuilder.getOrCreateMeta()).setExternalKey(arg_0));
        this.setValueAndUpdateMappings(paymentPath.addElement("payerPartyReference").addElement("href"), transferBuilder.getOrCreatePayerReceiver().getOrCreatePayerPartyReference()::setExternalReference);
        this.setValueAndUpdateMappings(paymentPath.addElement("receiverPartyReference").addElement("href"), transferBuilder.getOrCreatePayerReceiver().getOrCreateReceiverPartyReference()::setExternalReference);
        this.setQuantity(transferBuilder.getOrCreateQuantity(), paymentPath.addElement("paymentAmount"));
        this.setValueAndUpdateMappings(paymentPath.addElement("paymentDate").addElement("adjustedDate"), xmlValue -> transferBuilder.getOrCreateSettlementDate().getOrCreateAdjustedDate().setValue(Date.parse((String)xmlValue.replace("Z", ""))));
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)paymentPath.addElement("paymentType"), xmlValue -> this.synonymToEnumMap.getEnumValueOptional(FeeTypeEnum.class, xmlValue).map(transferBuilder.getOrCreateTransferExpression()::setPriceTransfer).isPresent(), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        if (transferBuilder.getTransferExpression() == null) {
            transferBuilder.getOrCreateTransferExpression().setPriceTransfer(FeeTypeEnum.NOVATION);
        }
        return transferInstructionBuilder.prune().hasData() ? Optional.of(transferInstructionBuilder.build()) : Optional.empty();
    }

    private Optional<QuantityChangeInstruction> getOutgoingQuantityChangeInstruction(Path synonymPath) {
        QuantityChangeDirectionEnum directionEnum;
        QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstructionBuilder = QuantityChangeInstruction.builder();
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder remainingQuantityBuilder = quantityChangeInstructionBuilder.getOrCreateChange(0).getOrCreateQuantity(0).getOrCreateValue();
        this.setQuantity(remainingQuantityBuilder, synonymPath.addElement("novationAmount").addElement("outstandingNotionalAmount"));
        this.setQuantity(remainingQuantityBuilder, synonymPath.addElement("remainingAmount"));
        if (remainingQuantityBuilder.getValue() == null) {
            this.setQuantity(remainingQuantityBuilder, synonymPath.addElement("novatedAmount"));
            directionEnum = QuantityChangeDirectionEnum.DECREASE;
        } else {
            directionEnum = QuantityChangeDirectionEnum.REPLACE;
        }
        return quantityChangeInstructionBuilder.prune().hasData() ? Optional.of(quantityChangeInstructionBuilder.setDirection(directionEnum).build()) : Optional.empty();
    }

    private void setQuantity(QuantitySchedule.QuantityScheduleBuilder quantityBuilder, Path basePath) {
        this.setValueAndUpdateMappings(basePath.addElement("amount"), xmlValue -> quantityBuilder.setValue(new BigDecimal((String)xmlValue)));
        this.setValueAndUpdateMappings(basePath.addElement("currency"), quantityBuilder.getOrCreateUnit().getOrCreateCurrency()::setValue);
    }
}

