/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.legaldocumentation.common.LegalAgreementIdentification;
import cdm.legaldocumentation.common.Resource;
import cdm.legaldocumentation.common.meta.LegalAgreementBaseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegalAgreementBase", builder=LegalAgreementBaseBuilderImpl.class, version="5.27.0")
@RuneDataType(value="LegalAgreementBase", model="cdm", builder=LegalAgreementBaseBuilderImpl.class, version="5.27.0")
public interface LegalAgreementBase
extends RosettaModelObject {
    public static final LegalAgreementBaseMeta metaData = new LegalAgreementBaseMeta();

    public Date getAgreementDate();

    public Date getEffectiveDate();

    public List<? extends Identifier> getIdentifier();

    public LegalAgreementIdentification getLegalAgreementIdentification();

    public List<? extends ReferenceWithMetaParty> getContractualParty();

    public List<? extends PartyRole> getOtherParty();

    public List<? extends Resource> getAttachment();

    public LegalAgreementBase build();

    public LegalAgreementBaseBuilder toBuilder();

    public static LegalAgreementBaseBuilder builder() {
        return new LegalAgreementBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends LegalAgreementBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegalAgreementBase> getType() {
        return LegalAgreementBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("agreementDate"), Date.class, (Object)this.getAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("identifier"), processor, Identifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalAgreementIdentification"), processor, LegalAgreementIdentification.class, this.getLegalAgreementIdentification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractualParty"), processor, ReferenceWithMetaParty.class, this.getContractualParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherParty"), processor, PartyRole.class, this.getOtherParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("attachment"), processor, Resource.class, this.getAttachment(), new AttributeMeta[0]);
    }

    public static class LegalAgreementBaseBuilderImpl
    implements LegalAgreementBaseBuilder {
        protected Date agreementDate;
        protected Date effectiveDate;
        protected List<Identifier.IdentifierBuilder> identifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected LegalAgreementIdentification.LegalAgreementIdentificationBuilder legalAgreementIdentification;
        protected List<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> contractualParty = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> otherParty = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected List<Resource.ResourceBuilder> attachment = new ArrayList<Resource.ResourceBuilder>();

        @Override
        @RosettaAttribute(value="agreementDate")
        @RuneAttribute(value="agreementDate")
        public Date getAgreementDate() {
            return this.agreementDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public List<? extends Identifier.IdentifierBuilder> getIdentifier() {
            return this.identifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateIdentifier(int index) {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.identifier, index, () -> {
                Identifier.IdentifierBuilder newIdentifier = Identifier.builder();
                return newIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="legalAgreementIdentification", isRequired=true)
        @RuneAttribute(value="legalAgreementIdentification", isRequired=true)
        public LegalAgreementIdentification.LegalAgreementIdentificationBuilder getLegalAgreementIdentification() {
            return this.legalAgreementIdentification;
        }

        @Override
        public LegalAgreementIdentification.LegalAgreementIdentificationBuilder getOrCreateLegalAgreementIdentification() {
            LegalAgreementIdentification.LegalAgreementIdentificationBuilder result = this.legalAgreementIdentification != null ? this.legalAgreementIdentification : (this.legalAgreementIdentification = LegalAgreementIdentification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractualParty", isRequired=true)
        @RuneAttribute(value="contractualParty", isRequired=true)
        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getContractualParty() {
            return this.contractualParty;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateContractualParty(int index) {
            if (this.contractualParty == null) {
                this.contractualParty = new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>();
            }
            return (ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder)this.getIndex(this.contractualParty, index, () -> {
                ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder newContractualParty = ReferenceWithMetaParty.builder();
                return newContractualParty;
            });
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public List<? extends PartyRole.PartyRoleBuilder> getOtherParty() {
            return this.otherParty;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreateOtherParty(int index) {
            if (this.otherParty == null) {
                this.otherParty = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.otherParty, index, () -> {
                PartyRole.PartyRoleBuilder newOtherParty = PartyRole.builder();
                return newOtherParty;
            });
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public List<? extends Resource.ResourceBuilder> getAttachment() {
            return this.attachment;
        }

        @Override
        public Resource.ResourceBuilder getOrCreateAttachment(int index) {
            if (this.attachment == null) {
                this.attachment = new ArrayList<Resource.ResourceBuilder>();
            }
            return (Resource.ResourceBuilder)this.getIndex(this.attachment, index, () -> {
                Resource.ResourceBuilder newAttachment = Resource.builder();
                return newAttachment;
            });
        }

        @Override
        @RosettaAttribute(value="agreementDate")
        @RuneAttribute(value="agreementDate")
        public LegalAgreementBaseBuilder setAgreementDate(Date _agreementDate) {
            this.agreementDate = _agreementDate == null ? null : _agreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public LegalAgreementBaseBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public LegalAgreementBaseBuilder addIdentifier(Identifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addIdentifier(Identifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addIdentifier(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.identifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public LegalAgreementBaseBuilder setIdentifier(List<? extends Identifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="legalAgreementIdentification", isRequired=true)
        @RuneAttribute(value="legalAgreementIdentification", isRequired=true)
        public LegalAgreementBaseBuilder setLegalAgreementIdentification(LegalAgreementIdentification _legalAgreementIdentification) {
            this.legalAgreementIdentification = _legalAgreementIdentification == null ? null : _legalAgreementIdentification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractualParty", isRequired=true)
        @RuneAttribute(value="contractualParty", isRequired=true)
        public LegalAgreementBaseBuilder addContractualParty(ReferenceWithMetaParty _contractualParty) {
            if (_contractualParty != null) {
                this.contractualParty.add(_contractualParty.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addContractualParty(ReferenceWithMetaParty _contractualParty, int idx) {
            this.getIndex(this.contractualParty, idx, () -> _contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addContractualPartyValue(Party _contractualParty) {
            this.getOrCreateContractualParty(-1).setValue(_contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addContractualPartyValue(Party _contractualParty, int idx) {
            this.getOrCreateContractualParty(idx).setValue(_contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addContractualParty(List<? extends ReferenceWithMetaParty> contractualPartys) {
            if (contractualPartys != null) {
                for (ReferenceWithMetaParty referenceWithMetaParty : contractualPartys) {
                    this.contractualParty.add(referenceWithMetaParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractualParty")
        public LegalAgreementBaseBuilder setContractualParty(List<? extends ReferenceWithMetaParty> contractualPartys) {
            this.contractualParty = contractualPartys == null ? new ArrayList<ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder>() : (List)contractualPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addContractualPartyValue(List<? extends Party> contractualPartys) {
            if (contractualPartys != null) {
                for (Party party : contractualPartys) {
                    this.addContractualPartyValue(party);
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder setContractualPartyValue(List<? extends Party> contractualPartys) {
            this.contractualParty.clear();
            if (contractualPartys != null) {
                contractualPartys.forEach(this::addContractualPartyValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public LegalAgreementBaseBuilder addOtherParty(PartyRole _otherParty) {
            if (_otherParty != null) {
                this.otherParty.add(_otherParty.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addOtherParty(PartyRole _otherParty, int idx) {
            this.getIndex(this.otherParty, idx, () -> _otherParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addOtherParty(List<? extends PartyRole> otherPartys) {
            if (otherPartys != null) {
                for (PartyRole partyRole : otherPartys) {
                    this.otherParty.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherParty")
        public LegalAgreementBaseBuilder setOtherParty(List<? extends PartyRole> otherPartys) {
            this.otherParty = otherPartys == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)otherPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public LegalAgreementBaseBuilder addAttachment(Resource _attachment) {
            if (_attachment != null) {
                this.attachment.add(_attachment.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addAttachment(Resource _attachment, int idx) {
            this.getIndex(this.attachment, idx, () -> _attachment.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder addAttachment(List<? extends Resource> attachments) {
            if (attachments != null) {
                for (Resource resource : attachments) {
                    this.attachment.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="attachment")
        public LegalAgreementBaseBuilder setAttachment(List<? extends Resource> attachments) {
            this.attachment = attachments == null ? new ArrayList<Resource.ResourceBuilder>() : (List)attachments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBase build() {
            return new LegalAgreementBaseImpl(this);
        }

        @Override
        public LegalAgreementBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder prune() {
            this.identifier = this.identifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.legalAgreementIdentification != null && !this.legalAgreementIdentification.prune().hasData()) {
                this.legalAgreementIdentification = null;
            }
            this.contractualParty = this.contractualParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.otherParty = this.otherParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.attachment = this.attachment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAgreementDate() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getIdentifier() != null && this.getIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLegalAgreementIdentification() != null && this.getLegalAgreementIdentification().hasData()) {
                return true;
            }
            if (this.getContractualParty() != null && this.getContractualParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOtherParty() != null && this.getOtherParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAttachment() != null && this.getAttachment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LegalAgreementBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegalAgreementBaseBuilder o = (LegalAgreementBaseBuilder)other;
            merger.mergeRosetta(this.getIdentifier(), o.getIdentifier(), this::getOrCreateIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalAgreementIdentification(), (RosettaModelObjectBuilder)o.getLegalAgreementIdentification(), this::setLegalAgreementIdentification);
            merger.mergeRosetta(this.getContractualParty(), o.getContractualParty(), this::getOrCreateContractualParty);
            merger.mergeRosetta(this.getOtherParty(), o.getOtherParty(), this::getOrCreateOtherParty);
            merger.mergeRosetta(this.getAttachment(), o.getAttachment(), this::getOrCreateAttachment);
            merger.mergeBasic((Object)this.getAgreementDate(), (Object)o.getAgreementDate(), this::setAgreementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalAgreementBase _that = this.getType().cast(o);
            if (!Objects.equals(this.agreementDate, _that.getAgreementDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.legalAgreementIdentification, _that.getLegalAgreementIdentification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualParty, _that.getContractualParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherParty, _that.getOtherParty())) {
                return false;
            }
            return ListEquals.listEquals(this.attachment, _that.getAttachment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreementDate != null ? this.agreementDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.legalAgreementIdentification != null ? this.legalAgreementIdentification.hashCode() : 0);
            _result = 31 * _result + (this.contractualParty != null ? this.contractualParty.hashCode() : 0);
            _result = 31 * _result + (this.otherParty != null ? this.otherParty.hashCode() : 0);
            _result = 31 * _result + (this.attachment != null ? this.attachment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalAgreementBaseBuilder {agreementDate=" + this.agreementDate + ", effectiveDate=" + this.effectiveDate + ", identifier=" + this.identifier + ", legalAgreementIdentification=" + this.legalAgreementIdentification + ", contractualParty=" + this.contractualParty + ", otherParty=" + this.otherParty + ", attachment=" + this.attachment + '}';
        }
    }

    public static interface LegalAgreementBaseBuilder
    extends LegalAgreementBase,
    RosettaModelObjectBuilder {
        public Identifier.IdentifierBuilder getOrCreateIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getIdentifier();

        public LegalAgreementIdentification.LegalAgreementIdentificationBuilder getOrCreateLegalAgreementIdentification();

        @Override
        public LegalAgreementIdentification.LegalAgreementIdentificationBuilder getLegalAgreementIdentification();

        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateContractualParty(int var1);

        public List<? extends ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder> getContractualParty();

        public PartyRole.PartyRoleBuilder getOrCreateOtherParty(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getOtherParty();

        public Resource.ResourceBuilder getOrCreateAttachment(int var1);

        public List<? extends Resource.ResourceBuilder> getAttachment();

        public LegalAgreementBaseBuilder setAgreementDate(Date var1);

        public LegalAgreementBaseBuilder setEffectiveDate(Date var1);

        public LegalAgreementBaseBuilder addIdentifier(Identifier var1);

        public LegalAgreementBaseBuilder addIdentifier(Identifier var1, int var2);

        public LegalAgreementBaseBuilder addIdentifier(List<? extends Identifier> var1);

        public LegalAgreementBaseBuilder setIdentifier(List<? extends Identifier> var1);

        public LegalAgreementBaseBuilder setLegalAgreementIdentification(LegalAgreementIdentification var1);

        public LegalAgreementBaseBuilder addContractualParty(ReferenceWithMetaParty var1);

        public LegalAgreementBaseBuilder addContractualParty(ReferenceWithMetaParty var1, int var2);

        public LegalAgreementBaseBuilder addContractualPartyValue(Party var1);

        public LegalAgreementBaseBuilder addContractualPartyValue(Party var1, int var2);

        public LegalAgreementBaseBuilder addContractualParty(List<? extends ReferenceWithMetaParty> var1);

        public LegalAgreementBaseBuilder setContractualParty(List<? extends ReferenceWithMetaParty> var1);

        public LegalAgreementBaseBuilder addContractualPartyValue(List<? extends Party> var1);

        public LegalAgreementBaseBuilder setContractualPartyValue(List<? extends Party> var1);

        public LegalAgreementBaseBuilder addOtherParty(PartyRole var1);

        public LegalAgreementBaseBuilder addOtherParty(PartyRole var1, int var2);

        public LegalAgreementBaseBuilder addOtherParty(List<? extends PartyRole> var1);

        public LegalAgreementBaseBuilder setOtherParty(List<? extends PartyRole> var1);

        public LegalAgreementBaseBuilder addAttachment(Resource var1);

        public LegalAgreementBaseBuilder addAttachment(Resource var1, int var2);

        public LegalAgreementBaseBuilder addAttachment(List<? extends Resource> var1);

        public LegalAgreementBaseBuilder setAttachment(List<? extends Resource> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("agreementDate"), Date.class, (Object)this.getAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("identifier"), processor, Identifier.IdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalAgreementIdentification"), processor, LegalAgreementIdentification.LegalAgreementIdentificationBuilder.class, this.getLegalAgreementIdentification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractualParty"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getContractualParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherParty"), processor, PartyRole.PartyRoleBuilder.class, this.getOtherParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("attachment"), processor, Resource.ResourceBuilder.class, this.getAttachment(), new AttributeMeta[0]);
        }

        public LegalAgreementBaseBuilder prune();
    }

    public static class LegalAgreementBaseImpl
    implements LegalAgreementBase {
        private final Date agreementDate;
        private final Date effectiveDate;
        private final List<? extends Identifier> identifier;
        private final LegalAgreementIdentification legalAgreementIdentification;
        private final List<? extends ReferenceWithMetaParty> contractualParty;
        private final List<? extends PartyRole> otherParty;
        private final List<? extends Resource> attachment;

        protected LegalAgreementBaseImpl(LegalAgreementBaseBuilder builder) {
            this.agreementDate = builder.getAgreementDate();
            this.effectiveDate = builder.getEffectiveDate();
            this.identifier = Optional.ofNullable(builder.getIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.legalAgreementIdentification = Optional.ofNullable(builder.getLegalAgreementIdentification()).map(f -> f.build()).orElse(null);
            this.contractualParty = Optional.ofNullable(builder.getContractualParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.otherParty = Optional.ofNullable(builder.getOtherParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.attachment = Optional.ofNullable(builder.getAttachment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="agreementDate")
        @RuneAttribute(value="agreementDate")
        public Date getAgreementDate() {
            return this.agreementDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public List<? extends Identifier> getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="legalAgreementIdentification", isRequired=true)
        @RuneAttribute(value="legalAgreementIdentification", isRequired=true)
        public LegalAgreementIdentification getLegalAgreementIdentification() {
            return this.legalAgreementIdentification;
        }

        @Override
        @RosettaAttribute(value="contractualParty", isRequired=true)
        @RuneAttribute(value="contractualParty", isRequired=true)
        public List<? extends ReferenceWithMetaParty> getContractualParty() {
            return this.contractualParty;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public List<? extends PartyRole> getOtherParty() {
            return this.otherParty;
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public List<? extends Resource> getAttachment() {
            return this.attachment;
        }

        @Override
        public LegalAgreementBase build() {
            return this;
        }

        @Override
        public LegalAgreementBaseBuilder toBuilder() {
            LegalAgreementBaseBuilder builder = LegalAgreementBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalAgreementBaseBuilder builder) {
            Optional.ofNullable(this.getAgreementDate()).ifPresent(builder::setAgreementDate);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getLegalAgreementIdentification()).ifPresent(builder::setLegalAgreementIdentification);
            Optional.ofNullable(this.getContractualParty()).ifPresent(builder::setContractualParty);
            Optional.ofNullable(this.getOtherParty()).ifPresent(builder::setOtherParty);
            Optional.ofNullable(this.getAttachment()).ifPresent(builder::setAttachment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalAgreementBase _that = this.getType().cast(o);
            if (!Objects.equals(this.agreementDate, _that.getAgreementDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.legalAgreementIdentification, _that.getLegalAgreementIdentification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualParty, _that.getContractualParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherParty, _that.getOtherParty())) {
                return false;
            }
            return ListEquals.listEquals(this.attachment, _that.getAttachment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.agreementDate != null ? this.agreementDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.legalAgreementIdentification != null ? this.legalAgreementIdentification.hashCode() : 0);
            _result = 31 * _result + (this.contractualParty != null ? this.contractualParty.hashCode() : 0);
            _result = 31 * _result + (this.otherParty != null ? this.otherParty.hashCode() : 0);
            _result = 31 * _result + (this.attachment != null ? this.attachment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalAgreementBase {agreementDate=" + this.agreementDate + ", effectiveDate=" + this.effectiveDate + ", identifier=" + this.identifier + ", legalAgreementIdentification=" + this.legalAgreementIdentification + ", contractualParty=" + this.contractualParty + ", otherParty=" + this.otherParty + ", attachment=" + this.attachment + '}';
        }
    }
}

