/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.VectorGrowthOperation;
import cdm.base.math.functions.VectorOperation;
import cdm.base.math.functions.VectorScalarOperation;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ApplyCompoundingFormulaDefault.class)
public abstract class ApplyCompoundingFormula
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected VectorGrowthOperation vectorGrowthOperation;
    @Inject
    protected VectorOperation vectorOperation;
    @Inject
    protected VectorScalarOperation vectorScalarOperation;

    public CalculatedRateDetails evaluate(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
        CalculatedRateDetails results;
        CalculatedRateDetails.CalculatedRateDetailsBuilder resultsBuilder = this.doEvaluate(observations, weights, yearFrac);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(CalculatedRateDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperC<BigDecimal> weightedObservations(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperC<BigDecimal> scaledAndWeightedObservations(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperC<BigDecimal> growthFactors(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperC<BigDecimal> growthCurve(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> finalValue(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> totalWeight(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> overallYearFrac(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> calculatedRate(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    public static class ApplyCompoundingFormulaDefault
    extends ApplyCompoundingFormula {
        @Override
        protected CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            if (observations == null) {
                observations = Collections.emptyList();
            }
            if (weights == null) {
                weights = Collections.emptyList();
            }
            CalculatedRateDetails.CalculatedRateDetailsBuilder results = CalculatedRateDetails.builder();
            return this.assignOutput(results, observations, weights, yearFrac);
        }

        protected CalculatedRateDetails.CalculatedRateDetailsBuilder assignOutput(CalculatedRateDetails.CalculatedRateDetailsBuilder results, List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            results.setAggregateValue((BigDecimal)this.finalValue(observations, weights, yearFrac).get());
            results.setAggregateWeight((BigDecimal)this.totalWeight(observations, weights, yearFrac).get());
            results.setCalculatedRate((BigDecimal)this.calculatedRate(observations, weights, yearFrac).get());
            results.addCompoundedGrowth(this.growthCurve(observations, weights, yearFrac).getMulti());
            results.addGrowthFactor(this.growthFactors(observations, weights, yearFrac).getMulti());
            results.addWeightedRates(this.weightedObservations(observations, weights, yearFrac).getMulti());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<BigDecimal> weightedObservations(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorOperation.evaluate(ArithmeticOperationEnum.MULTIPLY, observations, weights));
        }

        @Override
        protected MapperC<BigDecimal> scaledAndWeightedObservations(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorScalarOperation.evaluate(ArithmeticOperationEnum.MULTIPLY, this.weightedObservations(observations, weights, yearFrac).getMulti(), yearFrac));
        }

        @Override
        protected MapperC<BigDecimal> growthFactors(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorScalarOperation.evaluate(ArithmeticOperationEnum.ADD, this.scaledAndWeightedObservations(observations, weights, yearFrac).getMulti(), new BigDecimal("1.0")));
        }

        @Override
        protected MapperC<BigDecimal> growthCurve(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorGrowthOperation.evaluate(new BigDecimal("1.0"), this.growthFactors(observations, weights, yearFrac).getMulti()));
        }

        @Override
        protected MapperS<BigDecimal> finalValue(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return this.growthCurve(observations, weights, yearFrac).last();
        }

        @Override
        protected MapperS<BigDecimal> totalWeight(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(weights).sumBigDecimal();
        }

        @Override
        protected MapperS<BigDecimal> overallYearFrac(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperMaths.multiply(this.totalWeight(observations, weights, yearFrac), (Mapper)MapperS.of((Object)yearFrac));
        }

        @Override
        protected MapperS<BigDecimal> calculatedRate(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperMaths.divide((Mapper)MapperMaths.subtract(this.finalValue(observations, weights, yearFrac), (Mapper)MapperS.of((Object)BigDecimal.valueOf(1L))), this.overallYearFrac(observations, weights, yearFrac));
        }
    }
}

