/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.meta.CashflowRepresentationMeta;
import cdm.product.common.schedule.PaymentCalculationPeriod;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CashflowRepresentation", builder=CashflowRepresentationBuilderImpl.class, version="5.27.0")
@RuneDataType(value="CashflowRepresentation", model="cdm", builder=CashflowRepresentationBuilderImpl.class, version="5.27.0")
public interface CashflowRepresentation
extends RosettaModelObject {
    public static final CashflowRepresentationMeta metaData = new CashflowRepresentationMeta();

    public Boolean getCashflowsMatchParameters();

    public List<? extends PaymentCalculationPeriod> getPaymentCalculationPeriod();

    public CashflowRepresentation build();

    public CashflowRepresentationBuilder toBuilder();

    public static CashflowRepresentationBuilder builder() {
        return new CashflowRepresentationBuilderImpl();
    }

    default public RosettaMetaData<? extends CashflowRepresentation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashflowRepresentation> getType() {
        return CashflowRepresentation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashflowsMatchParameters"), Boolean.class, (Object)this.getCashflowsMatchParameters(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentCalculationPeriod"), processor, PaymentCalculationPeriod.class, this.getPaymentCalculationPeriod(), new AttributeMeta[0]);
    }

    public static class CashflowRepresentationBuilderImpl
    implements CashflowRepresentationBuilder {
        protected Boolean cashflowsMatchParameters;
        protected List<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder> paymentCalculationPeriod = new ArrayList<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder>();

        @Override
        @RosettaAttribute(value="cashflowsMatchParameters", isRequired=true)
        @RuneAttribute(value="cashflowsMatchParameters", isRequired=true)
        public Boolean getCashflowsMatchParameters() {
            return this.cashflowsMatchParameters;
        }

        @Override
        @RosettaAttribute(value="paymentCalculationPeriod")
        @RuneAttribute(value="paymentCalculationPeriod")
        public List<? extends PaymentCalculationPeriod.PaymentCalculationPeriodBuilder> getPaymentCalculationPeriod() {
            return this.paymentCalculationPeriod;
        }

        @Override
        public PaymentCalculationPeriod.PaymentCalculationPeriodBuilder getOrCreatePaymentCalculationPeriod(int index) {
            if (this.paymentCalculationPeriod == null) {
                this.paymentCalculationPeriod = new ArrayList<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder>();
            }
            return (PaymentCalculationPeriod.PaymentCalculationPeriodBuilder)this.getIndex(this.paymentCalculationPeriod, index, () -> {
                PaymentCalculationPeriod.PaymentCalculationPeriodBuilder newPaymentCalculationPeriod = PaymentCalculationPeriod.builder();
                return newPaymentCalculationPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="cashflowsMatchParameters", isRequired=true)
        @RuneAttribute(value="cashflowsMatchParameters", isRequired=true)
        public CashflowRepresentationBuilder setCashflowsMatchParameters(Boolean _cashflowsMatchParameters) {
            this.cashflowsMatchParameters = _cashflowsMatchParameters == null ? null : _cashflowsMatchParameters;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentCalculationPeriod")
        @RuneAttribute(value="paymentCalculationPeriod")
        public CashflowRepresentationBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod _paymentCalculationPeriod) {
            if (_paymentCalculationPeriod != null) {
                this.paymentCalculationPeriod.add(_paymentCalculationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public CashflowRepresentationBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod _paymentCalculationPeriod, int idx) {
            this.getIndex(this.paymentCalculationPeriod, idx, () -> _paymentCalculationPeriod.toBuilder());
            return this;
        }

        @Override
        public CashflowRepresentationBuilder addPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> paymentCalculationPeriods) {
            if (paymentCalculationPeriods != null) {
                for (PaymentCalculationPeriod paymentCalculationPeriod : paymentCalculationPeriods) {
                    this.paymentCalculationPeriod.add(paymentCalculationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentCalculationPeriod")
        public CashflowRepresentationBuilder setPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> paymentCalculationPeriods) {
            this.paymentCalculationPeriod = paymentCalculationPeriods == null ? new ArrayList<PaymentCalculationPeriod.PaymentCalculationPeriodBuilder>() : (List)paymentCalculationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CashflowRepresentation build() {
            return new CashflowRepresentationImpl(this);
        }

        @Override
        public CashflowRepresentationBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowRepresentationBuilder prune() {
            this.paymentCalculationPeriod = this.paymentCalculationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCashflowsMatchParameters() != null) {
                return true;
            }
            return this.getPaymentCalculationPeriod() != null && this.getPaymentCalculationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CashflowRepresentationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashflowRepresentationBuilder o = (CashflowRepresentationBuilder)other;
            merger.mergeRosetta(this.getPaymentCalculationPeriod(), o.getPaymentCalculationPeriod(), this::getOrCreatePaymentCalculationPeriod);
            merger.mergeBasic((Object)this.getCashflowsMatchParameters(), (Object)o.getCashflowsMatchParameters(), this::setCashflowsMatchParameters, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowRepresentation _that = this.getType().cast(o);
            if (!Objects.equals(this.cashflowsMatchParameters, _that.getCashflowsMatchParameters())) {
                return false;
            }
            return ListEquals.listEquals(this.paymentCalculationPeriod, _that.getPaymentCalculationPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashflowsMatchParameters != null ? this.cashflowsMatchParameters.hashCode() : 0);
            _result = 31 * _result + (this.paymentCalculationPeriod != null ? this.paymentCalculationPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowRepresentationBuilder {cashflowsMatchParameters=" + this.cashflowsMatchParameters + ", paymentCalculationPeriod=" + this.paymentCalculationPeriod + '}';
        }
    }

    public static interface CashflowRepresentationBuilder
    extends CashflowRepresentation,
    RosettaModelObjectBuilder {
        public PaymentCalculationPeriod.PaymentCalculationPeriodBuilder getOrCreatePaymentCalculationPeriod(int var1);

        public List<? extends PaymentCalculationPeriod.PaymentCalculationPeriodBuilder> getPaymentCalculationPeriod();

        public CashflowRepresentationBuilder setCashflowsMatchParameters(Boolean var1);

        public CashflowRepresentationBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod var1);

        public CashflowRepresentationBuilder addPaymentCalculationPeriod(PaymentCalculationPeriod var1, int var2);

        public CashflowRepresentationBuilder addPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> var1);

        public CashflowRepresentationBuilder setPaymentCalculationPeriod(List<? extends PaymentCalculationPeriod> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashflowsMatchParameters"), Boolean.class, (Object)this.getCashflowsMatchParameters(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentCalculationPeriod"), processor, PaymentCalculationPeriod.PaymentCalculationPeriodBuilder.class, this.getPaymentCalculationPeriod(), new AttributeMeta[0]);
        }

        public CashflowRepresentationBuilder prune();
    }

    public static class CashflowRepresentationImpl
    implements CashflowRepresentation {
        private final Boolean cashflowsMatchParameters;
        private final List<? extends PaymentCalculationPeriod> paymentCalculationPeriod;

        protected CashflowRepresentationImpl(CashflowRepresentationBuilder builder) {
            this.cashflowsMatchParameters = builder.getCashflowsMatchParameters();
            this.paymentCalculationPeriod = Optional.ofNullable(builder.getPaymentCalculationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="cashflowsMatchParameters", isRequired=true)
        @RuneAttribute(value="cashflowsMatchParameters", isRequired=true)
        public Boolean getCashflowsMatchParameters() {
            return this.cashflowsMatchParameters;
        }

        @Override
        @RosettaAttribute(value="paymentCalculationPeriod")
        @RuneAttribute(value="paymentCalculationPeriod")
        public List<? extends PaymentCalculationPeriod> getPaymentCalculationPeriod() {
            return this.paymentCalculationPeriod;
        }

        @Override
        public CashflowRepresentation build() {
            return this;
        }

        @Override
        public CashflowRepresentationBuilder toBuilder() {
            CashflowRepresentationBuilder builder = CashflowRepresentation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowRepresentationBuilder builder) {
            Optional.ofNullable(this.getCashflowsMatchParameters()).ifPresent(builder::setCashflowsMatchParameters);
            Optional.ofNullable(this.getPaymentCalculationPeriod()).ifPresent(builder::setPaymentCalculationPeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowRepresentation _that = this.getType().cast(o);
            if (!Objects.equals(this.cashflowsMatchParameters, _that.getCashflowsMatchParameters())) {
                return false;
            }
            return ListEquals.listEquals(this.paymentCalculationPeriod, _that.getPaymentCalculationPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashflowsMatchParameters != null ? this.cashflowsMatchParameters.hashCode() : 0);
            _result = 31 * _result + (this.paymentCalculationPeriod != null ? this.paymentCalculationPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowRepresentation {cashflowsMatchParameters=" + this.cashflowsMatchParameters + ", paymentCalculationPeriod=" + this.paymentCalculationPeriod + '}';
        }
    }
}

