/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate;

import cdm.base.math.Rounding;
import cdm.observable.asset.Price;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.floatingrate.meta.FloatingRateProcessingParametersMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FloatingRateProcessingParameters", builder=FloatingRateProcessingParametersBuilderImpl.class, version="5.27.0")
@RuneDataType(value="FloatingRateProcessingParameters", model="cdm", builder=FloatingRateProcessingParametersBuilderImpl.class, version="5.27.0")
public interface FloatingRateProcessingParameters
extends RosettaModelObject {
    public static final FloatingRateProcessingParametersMeta metaData = new FloatingRateProcessingParametersMeta();

    public Price getInitialRate();

    public BigDecimal getMultiplier();

    public BigDecimal getSpread();

    public RateTreatmentEnum getTreatment();

    public BigDecimal getCapRate();

    public BigDecimal getFloorRate();

    public Rounding getRounding();

    public NegativeInterestRateTreatmentEnum getNegativeTreatment();

    public FloatingRateProcessingParameters build();

    public FloatingRateProcessingParametersBuilder toBuilder();

    public static FloatingRateProcessingParametersBuilder builder() {
        return new FloatingRateProcessingParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateProcessingParameters> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateProcessingParameters> getType() {
        return FloatingRateProcessingParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("initialRate"), processor, Price.class, this.getInitialRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("treatment"), RateTreatmentEnum.class, (Object)this.getTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("capRate"), BigDecimal.class, (Object)this.getCapRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floorRate"), BigDecimal.class, (Object)this.getFloorRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negativeTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FloatingRateProcessingParametersBuilderImpl
    implements FloatingRateProcessingParametersBuilder {
        protected Price.PriceBuilder initialRate;
        protected BigDecimal multiplier;
        protected BigDecimal spread;
        protected RateTreatmentEnum treatment;
        protected BigDecimal capRate;
        protected BigDecimal floorRate;
        protected Rounding.RoundingBuilder rounding;
        protected NegativeInterestRateTreatmentEnum negativeTreatment;

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public Price.PriceBuilder getInitialRate() {
            return this.initialRate;
        }

        @Override
        public Price.PriceBuilder getOrCreateInitialRate() {
            Price.PriceBuilder result = this.initialRate != null ? this.initialRate : (this.initialRate = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="treatment")
        @RuneAttribute(value="treatment")
        public RateTreatmentEnum getTreatment() {
            return this.treatment;
        }

        @Override
        @RosettaAttribute(value="capRate")
        @RuneAttribute(value="capRate")
        public BigDecimal getCapRate() {
            return this.capRate;
        }

        @Override
        @RosettaAttribute(value="floorRate")
        @RuneAttribute(value="floorRate")
        public BigDecimal getFloorRate() {
            return this.floorRate;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="negativeTreatment")
        @RuneAttribute(value="negativeTreatment")
        public NegativeInterestRateTreatmentEnum getNegativeTreatment() {
            return this.negativeTreatment;
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public FloatingRateProcessingParametersBuilder setInitialRate(Price _initialRate) {
            this.initialRate = _initialRate == null ? null : _initialRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public FloatingRateProcessingParametersBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public FloatingRateProcessingParametersBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="treatment")
        @RuneAttribute(value="treatment")
        public FloatingRateProcessingParametersBuilder setTreatment(RateTreatmentEnum _treatment) {
            this.treatment = _treatment == null ? null : _treatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="capRate")
        @RuneAttribute(value="capRate")
        public FloatingRateProcessingParametersBuilder setCapRate(BigDecimal _capRate) {
            this.capRate = _capRate == null ? null : _capRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="floorRate")
        @RuneAttribute(value="floorRate")
        public FloatingRateProcessingParametersBuilder setFloorRate(BigDecimal _floorRate) {
            this.floorRate = _floorRate == null ? null : _floorRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public FloatingRateProcessingParametersBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="negativeTreatment")
        @RuneAttribute(value="negativeTreatment")
        public FloatingRateProcessingParametersBuilder setNegativeTreatment(NegativeInterestRateTreatmentEnum _negativeTreatment) {
            this.negativeTreatment = _negativeTreatment == null ? null : _negativeTreatment;
            return this;
        }

        @Override
        public FloatingRateProcessingParameters build() {
            return new FloatingRateProcessingParametersImpl(this);
        }

        @Override
        public FloatingRateProcessingParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateProcessingParametersBuilder prune() {
            if (this.initialRate != null && !this.initialRate.prune().hasData()) {
                this.initialRate = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInitialRate() != null && this.getInitialRate().hasData()) {
                return true;
            }
            if (this.getMultiplier() != null) {
                return true;
            }
            if (this.getSpread() != null) {
                return true;
            }
            if (this.getTreatment() != null) {
                return true;
            }
            if (this.getCapRate() != null) {
                return true;
            }
            if (this.getFloorRate() != null) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            return this.getNegativeTreatment() != null;
        }

        public FloatingRateProcessingParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateProcessingParametersBuilder o = (FloatingRateProcessingParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialRate(), (RosettaModelObjectBuilder)o.getInitialRate(), this::setInitialRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeBasic((Object)this.getMultiplier(), (Object)o.getMultiplier(), this::setMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpread(), (Object)o.getSpread(), this::setSpread, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTreatment(), (Object)o.getTreatment(), this::setTreatment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCapRate(), (Object)o.getCapRate(), this::setCapRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloorRate(), (Object)o.getFloorRate(), this::setFloorRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNegativeTreatment(), (Object)o.getNegativeTreatment(), this::setNegativeTreatment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateProcessingParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.treatment, (Object)_that.getTreatment())) {
                return false;
            }
            if (!Objects.equals(this.capRate, _that.getCapRate())) {
                return false;
            }
            if (!Objects.equals(this.floorRate, _that.getFloorRate())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            return Objects.equals((Object)this.negativeTreatment, (Object)_that.getNegativeTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.treatment != null ? ((Object)((Object)this.treatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.capRate != null ? this.capRate.hashCode() : 0);
            _result = 31 * _result + (this.floorRate != null ? this.floorRate.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.negativeTreatment != null ? ((Object)((Object)this.negativeTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateProcessingParametersBuilder {initialRate=" + this.initialRate + ", multiplier=" + this.multiplier + ", spread=" + this.spread + ", treatment=" + (Object)((Object)this.treatment) + ", capRate=" + this.capRate + ", floorRate=" + this.floorRate + ", rounding=" + this.rounding + ", negativeTreatment=" + (Object)((Object)this.negativeTreatment) + '}';
        }
    }

    public static interface FloatingRateProcessingParametersBuilder
    extends FloatingRateProcessingParameters,
    RosettaModelObjectBuilder {
        public Price.PriceBuilder getOrCreateInitialRate();

        @Override
        public Price.PriceBuilder getInitialRate();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public FloatingRateProcessingParametersBuilder setInitialRate(Price var1);

        public FloatingRateProcessingParametersBuilder setMultiplier(BigDecimal var1);

        public FloatingRateProcessingParametersBuilder setSpread(BigDecimal var1);

        public FloatingRateProcessingParametersBuilder setTreatment(RateTreatmentEnum var1);

        public FloatingRateProcessingParametersBuilder setCapRate(BigDecimal var1);

        public FloatingRateProcessingParametersBuilder setFloorRate(BigDecimal var1);

        public FloatingRateProcessingParametersBuilder setRounding(Rounding var1);

        public FloatingRateProcessingParametersBuilder setNegativeTreatment(NegativeInterestRateTreatmentEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("initialRate"), processor, Price.PriceBuilder.class, this.getInitialRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("treatment"), RateTreatmentEnum.class, (Object)this.getTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("capRate"), BigDecimal.class, (Object)this.getCapRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floorRate"), BigDecimal.class, (Object)this.getFloorRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negativeTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FloatingRateProcessingParametersBuilder prune();
    }

    public static class FloatingRateProcessingParametersImpl
    implements FloatingRateProcessingParameters {
        private final Price initialRate;
        private final BigDecimal multiplier;
        private final BigDecimal spread;
        private final RateTreatmentEnum treatment;
        private final BigDecimal capRate;
        private final BigDecimal floorRate;
        private final Rounding rounding;
        private final NegativeInterestRateTreatmentEnum negativeTreatment;

        protected FloatingRateProcessingParametersImpl(FloatingRateProcessingParametersBuilder builder) {
            this.initialRate = Optional.ofNullable(builder.getInitialRate()).map(f -> f.build()).orElse(null);
            this.multiplier = builder.getMultiplier();
            this.spread = builder.getSpread();
            this.treatment = builder.getTreatment();
            this.capRate = builder.getCapRate();
            this.floorRate = builder.getFloorRate();
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.negativeTreatment = builder.getNegativeTreatment();
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public Price getInitialRate() {
            return this.initialRate;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="treatment")
        @RuneAttribute(value="treatment")
        public RateTreatmentEnum getTreatment() {
            return this.treatment;
        }

        @Override
        @RosettaAttribute(value="capRate")
        @RuneAttribute(value="capRate")
        public BigDecimal getCapRate() {
            return this.capRate;
        }

        @Override
        @RosettaAttribute(value="floorRate")
        @RuneAttribute(value="floorRate")
        public BigDecimal getFloorRate() {
            return this.floorRate;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        @RosettaAttribute(value="negativeTreatment")
        @RuneAttribute(value="negativeTreatment")
        public NegativeInterestRateTreatmentEnum getNegativeTreatment() {
            return this.negativeTreatment;
        }

        @Override
        public FloatingRateProcessingParameters build() {
            return this;
        }

        @Override
        public FloatingRateProcessingParametersBuilder toBuilder() {
            FloatingRateProcessingParametersBuilder builder = FloatingRateProcessingParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateProcessingParametersBuilder builder) {
            Optional.ofNullable(this.getInitialRate()).ifPresent(builder::setInitialRate);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getTreatment()).ifPresent(builder::setTreatment);
            Optional.ofNullable(this.getCapRate()).ifPresent(builder::setCapRate);
            Optional.ofNullable(this.getFloorRate()).ifPresent(builder::setFloorRate);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getNegativeTreatment()).ifPresent(builder::setNegativeTreatment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateProcessingParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.treatment, (Object)_that.getTreatment())) {
                return false;
            }
            if (!Objects.equals(this.capRate, _that.getCapRate())) {
                return false;
            }
            if (!Objects.equals(this.floorRate, _that.getFloorRate())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            return Objects.equals((Object)this.negativeTreatment, (Object)_that.getNegativeTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.treatment != null ? ((Object)((Object)this.treatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.capRate != null ? this.capRate.hashCode() : 0);
            _result = 31 * _result + (this.floorRate != null ? this.floorRate.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.negativeTreatment != null ? ((Object)((Object)this.negativeTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateProcessingParameters {initialRate=" + this.initialRate + ", multiplier=" + this.multiplier + ", spread=" + this.spread + ", treatment=" + (Object)((Object)this.treatment) + ", capRate=" + this.capRate + ", floorRate=" + this.floorRate + ", rounding=" + this.rounding + ", negativeTreatment=" + (Object)((Object)this.negativeTreatment) + '}';
        }
    }
}

