/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.math.Rounding;
import cdm.product.asset.SpreadSchedule;
import cdm.product.common.settlement.RollFeature;
import cdm.product.common.settlement.meta.CommodityPriceReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityPriceReturnTerms", builder=CommodityPriceReturnTermsBuilderImpl.class, version="5.27.0")
@RuneDataType(value="CommodityPriceReturnTerms", model="cdm", builder=CommodityPriceReturnTermsBuilderImpl.class, version="5.27.0")
public interface CommodityPriceReturnTerms
extends RosettaModelObject {
    public static final CommodityPriceReturnTermsMeta metaData = new CommodityPriceReturnTermsMeta();

    public Rounding getRounding();

    public SpreadSchedule getSpread();

    public RollFeature getRollFeature();

    public BigDecimal getConversionFactor();

    public CommodityPriceReturnTerms build();

    public CommodityPriceReturnTermsBuilder toBuilder();

    public static CommodityPriceReturnTermsBuilder builder() {
        return new CommodityPriceReturnTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityPriceReturnTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityPriceReturnTerms> getType() {
        return CommodityPriceReturnTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, SpreadSchedule.class, this.getSpread(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rollFeature"), processor, RollFeature.class, this.getRollFeature(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommodityPriceReturnTermsBuilderImpl
    implements CommodityPriceReturnTermsBuilder {
        protected Rounding.RoundingBuilder rounding;
        protected SpreadSchedule.SpreadScheduleBuilder spread;
        protected RollFeature.RollFeatureBuilder rollFeature;
        protected BigDecimal conversionFactor;

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public SpreadSchedule.SpreadScheduleBuilder getSpread() {
            return this.spread;
        }

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpread() {
            SpreadSchedule.SpreadScheduleBuilder result = this.spread != null ? this.spread : (this.spread = SpreadSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rollFeature")
        @RuneAttribute(value="rollFeature")
        public RollFeature.RollFeatureBuilder getRollFeature() {
            return this.rollFeature;
        }

        @Override
        public RollFeature.RollFeatureBuilder getOrCreateRollFeature() {
            RollFeature.RollFeatureBuilder result = this.rollFeature != null ? this.rollFeature : (this.rollFeature = RollFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CommodityPriceReturnTermsBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CommodityPriceReturnTermsBuilder setSpread(SpreadSchedule _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rollFeature")
        @RuneAttribute(value="rollFeature")
        public CommodityPriceReturnTermsBuilder setRollFeature(RollFeature _rollFeature) {
            this.rollFeature = _rollFeature == null ? null : _rollFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public CommodityPriceReturnTermsBuilder setConversionFactor(BigDecimal _conversionFactor) {
            this.conversionFactor = _conversionFactor == null ? null : _conversionFactor;
            return this;
        }

        @Override
        public CommodityPriceReturnTerms build() {
            return new CommodityPriceReturnTermsImpl(this);
        }

        @Override
        public CommodityPriceReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder prune() {
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            if (this.spread != null && !this.spread.prune().hasData()) {
                this.spread = null;
            }
            if (this.rollFeature != null && !this.rollFeature.prune().hasData()) {
                this.rollFeature = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            if (this.getSpread() != null && this.getSpread().hasData()) {
                return true;
            }
            if (this.getRollFeature() != null && this.getRollFeature().hasData()) {
                return true;
            }
            return this.getConversionFactor() != null;
        }

        public CommodityPriceReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityPriceReturnTermsBuilder o = (CommodityPriceReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpread(), (RosettaModelObjectBuilder)o.getSpread(), this::setSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRollFeature(), (RosettaModelObjectBuilder)o.getRollFeature(), this::setRollFeature);
            merger.mergeBasic((Object)this.getConversionFactor(), (Object)o.getConversionFactor(), this::setConversionFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityPriceReturnTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals(this.rollFeature, _that.getRollFeature())) {
                return false;
            }
            return Objects.equals(this.conversionFactor, _that.getConversionFactor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.rollFeature != null ? this.rollFeature.hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityPriceReturnTermsBuilder {rounding=" + this.rounding + ", spread=" + this.spread + ", rollFeature=" + this.rollFeature + ", conversionFactor=" + this.conversionFactor + '}';
        }
    }

    public static interface CommodityPriceReturnTermsBuilder
    extends CommodityPriceReturnTerms,
    RosettaModelObjectBuilder {
        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpread();

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getSpread();

        public RollFeature.RollFeatureBuilder getOrCreateRollFeature();

        @Override
        public RollFeature.RollFeatureBuilder getRollFeature();

        public CommodityPriceReturnTermsBuilder setRounding(Rounding var1);

        public CommodityPriceReturnTermsBuilder setSpread(SpreadSchedule var1);

        public CommodityPriceReturnTermsBuilder setRollFeature(RollFeature var1);

        public CommodityPriceReturnTermsBuilder setConversionFactor(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, SpreadSchedule.SpreadScheduleBuilder.class, this.getSpread(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rollFeature"), processor, RollFeature.RollFeatureBuilder.class, this.getRollFeature(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommodityPriceReturnTermsBuilder prune();
    }

    public static class CommodityPriceReturnTermsImpl
    implements CommodityPriceReturnTerms {
        private final Rounding rounding;
        private final SpreadSchedule spread;
        private final RollFeature rollFeature;
        private final BigDecimal conversionFactor;

        protected CommodityPriceReturnTermsImpl(CommodityPriceReturnTermsBuilder builder) {
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.spread = Optional.ofNullable(builder.getSpread()).map(f -> f.build()).orElse(null);
            this.rollFeature = Optional.ofNullable(builder.getRollFeature()).map(f -> f.build()).orElse(null);
            this.conversionFactor = builder.getConversionFactor();
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public SpreadSchedule getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="rollFeature")
        @RuneAttribute(value="rollFeature")
        public RollFeature getRollFeature() {
            return this.rollFeature;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        public CommodityPriceReturnTerms build() {
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder toBuilder() {
            CommodityPriceReturnTermsBuilder builder = CommodityPriceReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityPriceReturnTermsBuilder builder) {
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getRollFeature()).ifPresent(builder::setRollFeature);
            Optional.ofNullable(this.getConversionFactor()).ifPresent(builder::setConversionFactor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityPriceReturnTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals(this.rollFeature, _that.getRollFeature())) {
                return false;
            }
            return Objects.equals(this.conversionFactor, _that.getConversionFactor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.rollFeature != null ? this.rollFeature.hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityPriceReturnTerms {rounding=" + this.rounding + ", spread=" + this.spread + ", rollFeature=" + this.rollFeature + ", conversionFactor=" + this.conversionFactor + '}';
        }
    }
}

