/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.party.BuyerSeller;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.meta.PriceQuantityMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeKey;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PriceQuantity", builder=PriceQuantityBuilderImpl.class, version="5.27.0")
@RuneDataType(value="PriceQuantity", model="cdm", builder=PriceQuantityBuilderImpl.class, version="5.27.0")
public interface PriceQuantity
extends RosettaModelObject,
GlobalKey {
    public static final PriceQuantityMeta metaData = new PriceQuantityMeta();

    public List<? extends FieldWithMetaPriceSchedule> getPrice();

    public List<? extends FieldWithMetaNonNegativeQuantitySchedule> getQuantity();

    public Observable getObservable();

    public BuyerSeller getBuyerSeller();

    public SettlementTerms getSettlementTerms();

    public AdjustableOrRelativeDate getEffectiveDate();

    public MetaFields getMeta();

    public PriceQuantity build();

    public PriceQuantityBuilder toBuilder();

    public static PriceQuantityBuilder builder() {
        return new PriceQuantityBuilderImpl();
    }

    default public RosettaMetaData<? extends PriceQuantity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PriceQuantity> getType() {
        return PriceQuantity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("price"), processor, FieldWithMetaPriceSchedule.class, this.getPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, FieldWithMetaNonNegativeQuantitySchedule.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observable"), processor, Observable.class, this.getObservable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.class, this.getBuyerSeller(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PriceQuantityBuilderImpl
    implements PriceQuantityBuilder {
        protected List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> price = new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>();
        protected List<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> quantity = new ArrayList<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder>();
        protected Observable.ObservableBuilder observable;
        protected BuyerSeller.BuyerSellerBuilder buyerSeller;
        protected SettlementTerms.SettlementTermsBuilder settlementTerms;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        @RuneScopedAttributeKey
        public List<? extends FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> getPrice() {
            return this.price;
        }

        @Override
        public FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder getOrCreatePrice(int index) {
            if (this.price == null) {
                this.price = new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>();
            }
            return (FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder)this.getIndex(this.price, index, () -> {
                FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder newPrice = FieldWithMetaPriceSchedule.builder();
                newPrice.getOrCreateMeta().addKey((Key)Key.builder().setScope("DOCUMENT"));
                return newPrice;
            });
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeKey
        public List<? extends FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> getQuantity() {
            return this.quantity;
        }

        @Override
        public FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int index) {
            if (this.quantity == null) {
                this.quantity = new ArrayList<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder>();
            }
            return (FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder)this.getIndex(this.quantity, index, () -> {
                FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder newQuantity = FieldWithMetaNonNegativeQuantitySchedule.builder();
                newQuantity.getOrCreateMeta().addKey((Key)Key.builder().setScope("DOCUMENT"));
                return newQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public Observable.ObservableBuilder getObservable() {
            return this.observable;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateObservable() {
            Observable.ObservableBuilder result = this.observable != null ? this.observable : (this.observable = Observable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyerSeller")
        @RuneAttribute(value="buyerSeller")
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller() {
            BuyerSeller.BuyerSellerBuilder result = this.buyerSeller != null ? this.buyerSeller : (this.buyerSeller = BuyerSeller.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public SettlementTerms.SettlementTermsBuilder getSettlementTerms() {
            return this.settlementTerms;
        }

        @Override
        public SettlementTerms.SettlementTermsBuilder getOrCreateSettlementTerms() {
            SettlementTerms.SettlementTermsBuilder result = this.settlementTerms != null ? this.settlementTerms : (this.settlementTerms = SettlementTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        @RuneScopedAttributeKey
        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule _price) {
            if (_price != null) {
                this.price.add(_price.toBuilder());
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule _price, int idx) {
            this.getIndex(this.price, idx, () -> _price.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addPriceValue(PriceSchedule _price) {
            this.getOrCreatePrice(-1).setValue(_price.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addPriceValue(PriceSchedule _price, int idx) {
            this.getOrCreatePrice(idx).setValue(_price.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addPrice(List<? extends FieldWithMetaPriceSchedule> prices) {
            if (prices != null) {
                for (FieldWithMetaPriceSchedule fieldWithMetaPriceSchedule : prices) {
                    this.price.add(fieldWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="price")
        @RuneScopedAttributeKey
        public PriceQuantityBuilder setPrice(List<? extends FieldWithMetaPriceSchedule> prices) {
            this.price = prices == null ? new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>() : (List)prices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PriceQuantityBuilder addPriceValue(List<? extends PriceSchedule> prices) {
            if (prices != null) {
                for (PriceSchedule priceSchedule : prices) {
                    this.addPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setPriceValue(List<? extends PriceSchedule> prices) {
            this.price.clear();
            if (prices != null) {
                prices.forEach(this::addPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeKey
        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule _quantity) {
            if (_quantity != null) {
                this.quantity.add(_quantity.toBuilder());
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule _quantity, int idx) {
            this.getIndex(this.quantity, idx, () -> _quantity.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule _quantity) {
            this.getOrCreateQuantity(-1).setValue(_quantity.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule _quantity, int idx) {
            this.getOrCreateQuantity(idx).setValue(_quantity.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule : quantitys) {
                    this.quantity.add(fieldWithMetaNonNegativeQuantitySchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeKey
        public PriceQuantityBuilder setQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> quantitys) {
            this.quantity = quantitys == null ? new ArrayList<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder>() : (List)quantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (NonNegativeQuantitySchedule nonNegativeQuantitySchedule : quantitys) {
                    this.addQuantityValue(nonNegativeQuantitySchedule);
                }
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            this.quantity.clear();
            if (quantitys != null) {
                quantitys.forEach(this::addQuantityValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public PriceQuantityBuilder setObservable(Observable _observable) {
            this.observable = _observable == null ? null : _observable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSeller")
        @RuneAttribute(value="buyerSeller")
        public PriceQuantityBuilder setBuyerSeller(BuyerSeller _buyerSeller) {
            this.buyerSeller = _buyerSeller == null ? null : _buyerSeller.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public PriceQuantityBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public PriceQuantityBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PriceQuantityBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PriceQuantity build() {
            return new PriceQuantityImpl(this);
        }

        @Override
        public PriceQuantityBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceQuantityBuilder prune() {
            this.price = this.price.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.quantity = this.quantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.observable != null && !this.observable.prune().hasData()) {
                this.observable = null;
            }
            if (this.buyerSeller != null && !this.buyerSeller.prune().hasData()) {
                this.buyerSeller = null;
            }
            if (this.settlementTerms != null && !this.settlementTerms.prune().hasData()) {
                this.settlementTerms = null;
            }
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPrice() != null && this.getPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getObservable() != null && this.getObservable().hasData()) {
                return true;
            }
            if (this.getBuyerSeller() != null && this.getBuyerSeller().hasData()) {
                return true;
            }
            if (this.getSettlementTerms() != null && this.getSettlementTerms().hasData()) {
                return true;
            }
            return this.getEffectiveDate() != null && this.getEffectiveDate().hasData();
        }

        public PriceQuantityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceQuantityBuilder o = (PriceQuantityBuilder)other;
            merger.mergeRosetta(this.getPrice(), o.getPrice(), this::getOrCreatePrice);
            merger.mergeRosetta(this.getQuantity(), o.getQuantity(), this::getOrCreateQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservable(), (RosettaModelObjectBuilder)o.getObservable(), this::setObservable);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSeller(), (RosettaModelObjectBuilder)o.getBuyerSeller(), this::setBuyerSeller);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementTerms(), (RosettaModelObjectBuilder)o.getSettlementTerms(), this::setSettlementTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceQuantity _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.price, _that.getPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.settlementTerms, _that.getSettlementTerms())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.settlementTerms != null ? this.settlementTerms.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceQuantityBuilder {price=" + this.price + ", quantity=" + this.quantity + ", observable=" + this.observable + ", buyerSeller=" + this.buyerSeller + ", settlementTerms=" + this.settlementTerms + ", effectiveDate=" + this.effectiveDate + ", meta=" + this.meta + '}';
        }
    }

    public static interface PriceQuantityBuilder
    extends PriceQuantity,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder getOrCreatePrice(int var1);

        public List<? extends FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> getPrice();

        public FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int var1);

        public List<? extends FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> getQuantity();

        public Observable.ObservableBuilder getOrCreateObservable();

        @Override
        public Observable.ObservableBuilder getObservable();

        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller();

        @Override
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller();

        public SettlementTerms.SettlementTermsBuilder getOrCreateSettlementTerms();

        @Override
        public SettlementTerms.SettlementTermsBuilder getSettlementTerms();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule var1);

        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule var1, int var2);

        public PriceQuantityBuilder addPriceValue(PriceSchedule var1);

        public PriceQuantityBuilder addPriceValue(PriceSchedule var1, int var2);

        public PriceQuantityBuilder addPrice(List<? extends FieldWithMetaPriceSchedule> var1);

        public PriceQuantityBuilder setPrice(List<? extends FieldWithMetaPriceSchedule> var1);

        public PriceQuantityBuilder addPriceValue(List<? extends PriceSchedule> var1);

        public PriceQuantityBuilder setPriceValue(List<? extends PriceSchedule> var1);

        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule var1);

        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule var1, int var2);

        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule var1);

        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule var1, int var2);

        public PriceQuantityBuilder addQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder setQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder setObservable(Observable var1);

        public PriceQuantityBuilder setBuyerSeller(BuyerSeller var1);

        public PriceQuantityBuilder setSettlementTerms(SettlementTerms var1);

        public PriceQuantityBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public PriceQuantityBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("price"), processor, FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder.class, this.getPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observable"), processor, Observable.ObservableBuilder.class, this.getObservable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.BuyerSellerBuilder.class, this.getBuyerSeller(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PriceQuantityBuilder prune();
    }

    public static class PriceQuantityImpl
    implements PriceQuantity {
        private final List<? extends FieldWithMetaPriceSchedule> price;
        private final List<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity;
        private final Observable observable;
        private final BuyerSeller buyerSeller;
        private final SettlementTerms settlementTerms;
        private final AdjustableOrRelativeDate effectiveDate;
        private final MetaFields meta;

        protected PriceQuantityImpl(PriceQuantityBuilder builder) {
            this.price = Optional.ofNullable(builder.getPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.observable = Optional.ofNullable(builder.getObservable()).map(f -> f.build()).orElse(null);
            this.buyerSeller = Optional.ofNullable(builder.getBuyerSeller()).map(f -> f.build()).orElse(null);
            this.settlementTerms = Optional.ofNullable(builder.getSettlementTerms()).map(f -> f.build()).orElse(null);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        @RuneScopedAttributeKey
        public List<? extends FieldWithMetaPriceSchedule> getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeKey
        public List<? extends FieldWithMetaNonNegativeQuantitySchedule> getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public Observable getObservable() {
            return this.observable;
        }

        @Override
        @RosettaAttribute(value="buyerSeller")
        @RuneAttribute(value="buyerSeller")
        public BuyerSeller getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public SettlementTerms getSettlementTerms() {
            return this.settlementTerms;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PriceQuantity build() {
            return this;
        }

        @Override
        public PriceQuantityBuilder toBuilder() {
            PriceQuantityBuilder builder = PriceQuantity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceQuantityBuilder builder) {
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getObservable()).ifPresent(builder::setObservable);
            Optional.ofNullable(this.getBuyerSeller()).ifPresent(builder::setBuyerSeller);
            Optional.ofNullable(this.getSettlementTerms()).ifPresent(builder::setSettlementTerms);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceQuantity _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.price, _that.getPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.settlementTerms, _that.getSettlementTerms())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.settlementTerms != null ? this.settlementTerms.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceQuantity {price=" + this.price + ", quantity=" + this.quantity + ", observable=" + this.observable + ", buyerSeller=" + this.buyerSeller + ", settlementTerms=" + this.settlementTerms + ", effectiveDate=" + this.effectiveDate + ", meta=" + this.meta + '}';
        }
    }
}

