/*
 * Decompiled with CFR 0.152.
 */
package org.isda.cdm.qualify;

import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandler;
import com.rosetta.util.CollectionUtils;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class EconomicTermsQualificationHandler
implements QualificationHandler<EconomicTerms, ContractualProduct, ContractualProduct.ContractualProductBuilder> {
    public Class<EconomicTerms> getQualifiableClass() {
        return EconomicTerms.class;
    }

    public EconomicTerms getQualifiableObject(ContractualProduct contractualProduct) {
        return Optional.ofNullable(contractualProduct).map(ContractualProduct::getEconomicTerms).orElse(null);
    }

    public String getQualifier(ContractualProduct contractualProduct) {
        return Optional.ofNullable(contractualProduct).map(ProductBase::getProductTaxonomy).orElse(Collections.emptyList()).stream().map(ProductTaxonomy::getProductQualifier).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void setQualifier(ContractualProduct.ContractualProductBuilder contractualProductBuilder, String qualifier) {
        ProductTaxonomy.ProductTaxonomyBuilder productTaxonomyBuilder = CollectionUtils.emptyIfNull(contractualProductBuilder.getProductTaxonomy()).stream().filter(t -> t.getProductQualifier() != null).findFirst().orElse(null);
        if (productTaxonomyBuilder != null) {
            productTaxonomyBuilder.setProductQualifier(qualifier).setSource(TaxonomySourceEnum.ISDA);
        } else {
            contractualProductBuilder.addProductTaxonomy(ProductTaxonomy.builder().setProductQualifier(qualifier).setSource(TaxonomySourceEnum.ISDA));
        }
    }
}

