/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.base.CharMatcher;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.Named;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.joda.convert.ToString;

public abstract class TypedString<T extends TypedString<T>>
implements Named,
Comparable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;

    protected TypedString(String name) {
        this.name = ArgChecker.notEmpty(name, "name");
    }

    protected TypedString(String name, Pattern pattern, String msg) {
        ArgChecker.notEmpty(name, "name");
        ArgChecker.notNull(pattern, "pattern");
        ArgChecker.notEmpty(msg, "msg");
        if (!pattern.matcher(name).matches()) {
            throw new IllegalArgumentException(msg);
        }
        this.name = name;
    }

    protected TypedString(String name, CharMatcher matcher, String msg) {
        ArgChecker.notEmpty(name, "name");
        ArgChecker.notNull(matcher, "pattern");
        ArgChecker.notEmpty(msg, "msg");
        if (!matcher.matchesAllOf((CharSequence)name)) {
            throw new IllegalArgumentException(msg);
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final int compareTo(T other) {
        return this.name.compareTo(((TypedString)other).toString());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TypedString other = (TypedString)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode() ^ this.getClass().hashCode();
    }

    @ToString
    public final String toString() {
        return this.name;
    }
}

