/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.base.Throwables;
import com.opengamma.strata.collect.UncheckedReflectiveOperationException;
import com.opengamma.strata.collect.function.CheckedBiConsumer;
import com.opengamma.strata.collect.function.CheckedBiFunction;
import com.opengamma.strata.collect.function.CheckedBiPredicate;
import com.opengamma.strata.collect.function.CheckedBinaryOperator;
import com.opengamma.strata.collect.function.CheckedConsumer;
import com.opengamma.strata.collect.function.CheckedFunction;
import com.opengamma.strata.collect.function.CheckedPredicate;
import com.opengamma.strata.collect.function.CheckedRunnable;
import com.opengamma.strata.collect.function.CheckedSupplier;
import com.opengamma.strata.collect.function.CheckedUnaryOperator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class Unchecked {
    private Unchecked() {
    }

    public static void wrap(CheckedRunnable block) {
        try {
            block.run();
        }
        catch (Throwable ex) {
            throw Unchecked.propagate(ex);
        }
    }

    public static <T> T wrap(CheckedSupplier<T> block) {
        try {
            return block.get();
        }
        catch (Throwable ex) {
            throw Unchecked.propagate(ex);
        }
    }

    public static Runnable runnable(CheckedRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T, R> Function<T, R> function(CheckedFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> biFunction(CheckedBiFunction<T, U, R> function) {
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T> UnaryOperator<T> unaryOperator(CheckedUnaryOperator<T> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T> BinaryOperator<T> binaryOperator(CheckedBinaryOperator<T> function) {
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T> Predicate<T> predicate(CheckedPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> biPredicate(CheckedBiPredicate<T, U> predicate) {
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> biConsumer(CheckedBiConsumer<T, U> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static <R> Supplier<R> supplier(CheckedSupplier<R> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable ex) {
                throw Unchecked.propagate(ex);
            }
        };
    }

    public static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throw Unchecked.propagate(((InvocationTargetException)throwable).getCause());
        }
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        if (throwable instanceof ReflectiveOperationException) {
            throw new UncheckedReflectiveOperationException((ReflectiveOperationException)throwable);
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

