/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import com.opengamma.strata.collect.io.ResourceLocator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;

public final class ResourceConfig {
    private static final Logger log = Logger.getLogger(ResourceConfig.class.getName());
    private static final String CONFIG_PACKAGE = "com/opengamma/strata/config/";
    private static final ImmutableList<String> DEFAULT_DIRS = ImmutableList.of((Object)"base", (Object)"base1", (Object)"base2", (Object)"base3", (Object)"base4", (Object)"base5", (Object)"base6", (Object)"base7", (Object)"base8", (Object)"base9", (Object)"library", (Object)"library1", (Object[])new String[]{"library2", "library3", "library4", "library5", "library6", "library7", "library8", "library9", "application", "application1", "application2", "application3", "application4", "application5", "application6", "application7", "application8", "application9"});
    public static final String RESOURCE_DIRS_PROPERTY = "com.opengamma.strata.config.directories";
    private static final ImmutableList<String> RESOURCE_DIRS;
    private static final String CHAIN_SECTION = "chain";
    private static final String CHAIN_NEXT = "chainNextFile";
    private static final String CHAIN_REMOVE = "chainRemoveSections";

    public static IniFile combinedIniFile(String resourceName) {
        ArgChecker.notNull(resourceName, "resourceName");
        return ResourceConfig.combinedIniFile(ResourceConfig.orderedResources(resourceName));
    }

    public static IniFile combinedIniFile(List<ResourceLocator> resources) {
        ArgChecker.notNull(resources, "resources");
        LinkedHashMap<String, PropertySet> sectionMap = new LinkedHashMap<String, PropertySet>();
        for (ResourceLocator resource : resources) {
            IniFile file = IniFile.of(resource.getCharSource());
            if (file.contains(CHAIN_SECTION)) {
                PropertySet chainSection = file.section(CHAIN_SECTION);
                if (chainSection.contains(CHAIN_NEXT) && !Boolean.parseBoolean(chainSection.value(CHAIN_NEXT))) {
                    sectionMap.clear();
                } else {
                    sectionMap.keySet().removeAll((Collection<?>)chainSection.valueList(CHAIN_REMOVE));
                }
            }
            for (String sectionName : file.asMap().keySet()) {
                if (sectionName.equals(CHAIN_SECTION)) continue;
                sectionMap.merge(sectionName, file.section(sectionName), PropertySet::overrideWith);
            }
        }
        return IniFile.of(sectionMap);
    }

    public static List<ResourceLocator> orderedResources(String resourceName) {
        ArgChecker.notNull(resourceName, "resourceName");
        return Unchecked.wrap(() -> ResourceConfig.orderedResources0(resourceName));
    }

    private static List<ResourceLocator> orderedResources0(String classpathResourceName) throws IOException {
        ClassLoader classLoader = ResourceLocator.classLoader();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ResourceLocator> result = new ArrayList<ResourceLocator>();
        block4: for (String dir : RESOURCE_DIRS) {
            String name = CONFIG_PACKAGE + dir + "/" + classpathResourceName;
            names.add(name);
            ArrayList<URL> urls = Collections.list(classLoader.getResources(name));
            switch (urls.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    result.add(ResourceLocator.ofClasspathUrl((URL)urls.get(0)));
                    continue block4;
                }
            }
            ResourceLocator baseResource = ResourceLocator.ofClasspathUrl((URL)urls.get(0));
            for (int i = 1; i < urls.size(); ++i) {
                ResourceLocator otherResource = ResourceLocator.ofClasspathUrl((URL)urls.get(i));
                if (baseResource.getByteSource().contentEquals(otherResource.getByteSource())) continue;
                log.severe("More than one file found on the classpath: " + name + ": " + urls);
                throw new IllegalStateException("More than one file found on the classpath: " + name + ": " + urls);
            }
            result.add(baseResource);
        }
        if (result.isEmpty()) {
            log.severe("No resource files found on the classpath: " + names);
            throw new IllegalStateException("No files found on the classpath: " + names);
        }
        log.config(() -> "Resources found: " + result);
        return result;
    }

    private ResourceConfig() {
    }

    static {
        Object dirs = DEFAULT_DIRS;
        String property = null;
        try {
            property = System.getProperty(RESOURCE_DIRS_PROPERTY);
        }
        catch (Exception ex) {
            log.warning("Unable to access system property: " + ex.toString());
        }
        if (property != null && !property.isEmpty()) {
            try {
                dirs = Splitter.on((char)',').trimResults().splitToList((CharSequence)property);
            }
            catch (Exception ex) {
                log.warning("Invalid system property: " + property + ": " + ex.toString());
            }
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                String dir = (String)iterator.next();
                if (dir.matches("[A-Za-z0-9-]+")) continue;
                log.warning("Invalid system property directory, must match regex [A-Za-z0-9-]+: " + dir);
            }
        }
        log.config("Using directories: " + dirs);
        RESOURCE_DIRS = ImmutableList.copyOf(dirs);
    }
}

