/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.timeseries;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.collect.ArgChecker;
import java.time.LocalDate;
import org.joda.beans.JodaBeanUtils;

public final class LocalDateDoublePoint
implements Comparable<LocalDateDoublePoint> {
    private final LocalDate date;
    private final double value;

    public static LocalDateDoublePoint of(LocalDate date, double value) {
        return new LocalDateDoublePoint(date, value);
    }

    private LocalDateDoublePoint(LocalDate date, double value) {
        this.date = ArgChecker.notNull(date, "date");
        this.value = value;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public double getValue() {
        return this.value;
    }

    public LocalDateDoublePoint withDate(LocalDate date) {
        return LocalDateDoublePoint.of(date, this.value);
    }

    public LocalDateDoublePoint withValue(double value) {
        return LocalDateDoublePoint.of(this.date, value);
    }

    @Override
    public int compareTo(LocalDateDoublePoint other) {
        return ComparisonChain.start().compare((Comparable)this.date, (Comparable)other.date).compare(this.value, other.value).result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalDateDoublePoint) {
            LocalDateDoublePoint other = (LocalDateDoublePoint)obj;
            return this.date.equals(other.date) && JodaBeanUtils.equal((double)this.value, (double)other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ JodaBeanUtils.hashCode((double)this.value);
    }

    public String toString() {
        return new StringBuilder(24).append('(').append(this.date).append('=').append(this.value).append(')').toString();
    }
}

