/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.reports;

import com.regnosys.rosetta.common.RegPaths;
import com.rosetta.model.lib.ModelReportId;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RegReportPaths
extends RegPaths {
    public static final Path REGULATORY_REPORTING_PATH = Paths.get("regulatory-reporting", new String[0]);
    public static final String REPORT_EXPECTATIONS_FILE_NAME = "report-expectations.json";

    public static RegReportPaths get(Path resourcesPath) {
        return Files.exists(resourcesPath.resolve(REGULATORY_REPORTING_PATH).resolve(INPUT_PATH), new LinkOption[0]) ? RegReportPaths.getDefault() : RegReportPaths.getLegacy();
    }

    public static RegReportPaths getDefault() {
        Path rootPath = REGULATORY_REPORTING_PATH;
        return new RegReportPaths(rootPath, rootPath.resolve(INPUT_PATH), rootPath.resolve(OUTPUT_PATH), rootPath.resolve(CONFIG_PATH), rootPath.resolve(LOOKUP_PATH));
    }

    public static RegReportPaths getLegacy() {
        Path dataPath = REGULATORY_REPORTING_PATH.resolve(LEGACY_DATA_PATH);
        Path lookup = REGULATORY_REPORTING_PATH.resolve(LOOKUP_PATH);
        return new RegReportPaths(dataPath, dataPath, dataPath, dataPath, lookup);
    }

    public RegReportPaths(Path rootPath, Path input, Path output, Path config, Path lookup) {
        super(rootPath, input, output, config, lookup);
    }

    public static Path getReportExpectationsFilePath(Path outputPath, ModelReportId reportIdentifier, String dataSetName) {
        return RegReportPaths.getOutputDataSetPath(outputPath, reportIdentifier, dataSetName).resolve(REPORT_EXPECTATIONS_FILE_NAME);
    }

    @Deprecated
    public static Path getLegacyReportPath(Path outputPath, ModelReportId reportIdentifier) {
        return outputPath.resolve(RegReportPaths.legacyDirectoryName(reportIdentifier));
    }

    @Deprecated
    public static Path getLegacyKeyValueExpectationFilePath(Path outputPath, ModelReportId reportIdentifier, String dataSetName, Path inputPath) {
        return RegReportPaths.getLegacyReportDataSetPath(outputPath, reportIdentifier, dataSetName).resolve(inputPath.getFileName().toString().replace(".json", "-key-value.json"));
    }

    public static Path getReportExpectationFilePath(Path outputPath, ModelReportId reportIdentifier, String dataSetName, Path inputPath) {
        return RegReportPaths.getOutputDataSetPath(outputPath, reportIdentifier, dataSetName).resolve(inputPath.getFileName().toString().replace(".json", "-report.json"));
    }

    @Deprecated
    public static String legacyDirectoryName(ModelReportId id) {
        return id.joinRegulatoryReference("", "-").replace("_", "-").toLowerCase();
    }

    @Deprecated
    public static Path getLegacyReportDataSetPath(Path outputPath, ModelReportId reportIdentifier, String dataSetName) {
        return RegReportPaths.getLegacyReportPath(outputPath, reportIdentifier).resolve(RegReportPaths.directoryNameOfDataset(dataSetName));
    }
}

