/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapperCreator;
import java.io.IOException;
import java.net.URL;

public class RosettaCsvMapper
extends CsvMapper {
    private final CsvSchema defaultSchema = CsvSchema.emptySchema().withHeader();

    public <T> T readValue(String content, Class<T> valueType) throws JsonMappingException {
        try {
            return (T)super.readerFor(valueType).with((FormatSchema)this.defaultSchema).readValue(content, valueType);
        }
        catch (IOException e) {
            throw new JsonMappingException(null, String.format("IOException (of type %s): %s", e.getClass().getName(), ClassUtil.exceptionMessage((Throwable)e)));
        }
    }

    public <T> T readValue(URL src, Class<T> valueType) throws IOException {
        return (T)super.readerFor(valueType).with((FormatSchema)this.defaultSchema).readValue(src, valueType);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        SerializationConfig config = this.getSerializationConfig();
        RosettaCsvObjectWriter rosettaCsvObjectWriter = new RosettaCsvObjectWriter(this, config);
        return rosettaCsvObjectWriter.writeValueAsString(value);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig config = this.getSerializationConfig();
        return new RosettaCsvObjectWriter(this, config);
    }

    public static RosettaCsvMapper createCsvObjectMapper() {
        return (RosettaCsvMapper)RosettaObjectMapperCreator.forCSV().create();
    }

    private static class RosettaCsvObjectWriter
    extends ObjectWriter {
        private final CsvMapper mapper;

        protected RosettaCsvObjectWriter(CsvMapper mapper, SerializationConfig config) {
            super((ObjectMapper)mapper, config);
            this.mapper = mapper;
        }

        public String writeValueAsString(Object value) throws JsonProcessingException {
            CsvSchema schema = this.mapper.schemaFor(value.getClass()).withHeader();
            ObjectWriter writer = this.mapper.writer((FormatSchema)schema);
            return writer.writeValueAsString(value);
        }
    }
}

