/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.translation;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingDelegate;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.PostProcessStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingProcessorStep
implements PostProcessStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingProcessorStep.class);
    private final int mappingMaxTimeout;
    private final List<MappingDelegate> mappingDelegates;
    private final ExecutorService executor;
    private final List<CompletableFuture<?>> invokedTasks;
    private final MappingContext context;
    static final Comparator<MappingDelegate> MAPPING_DELEGATE_COMPARATOR = new PathComparator().thenComparing(p -> p.getClass().getName());

    public MappingProcessorStep(Collection<MappingProcessor> mappingProcessors, MappingContext context) {
        this.context = context;
        this.mappingDelegates = new ArrayList<MappingProcessor>(mappingProcessors);
        this.mappingDelegates.sort(MAPPING_DELEGATE_COMPARATOR);
        this.executor = context.getExecutor();
        this.invokedTasks = context.getInvokedTasks();
        this.mappingMaxTimeout = 3000;
    }

    public MappingProcessorStep(Collection<MappingProcessor> mappingProcessors, MappingContext context, int mappingMaxTimeout) {
        this.context = context;
        this.mappingDelegates = new ArrayList<MappingProcessor>(mappingProcessors);
        this.mappingDelegates.sort(MAPPING_DELEGATE_COMPARATOR);
        this.executor = context.getExecutor();
        this.invokedTasks = context.getInvokedTasks();
        this.mappingMaxTimeout = mappingMaxTimeout;
    }

    public Integer getPriority() {
        return 1;
    }

    public String getName() {
        return "Mapping Processor";
    }

    public <T extends RosettaModelObject> PostProcessorReport runProcessStep(Class<? extends T> topClass, T instance) {
        LOGGER.debug("About to run {} mappingDelegates", (Object)this.mappingDelegates.size());
        Stopwatch stopwatch = Stopwatch.createStarted();
        RosettaModelObjectBuilder builder = instance.toBuilder();
        Future<?> mappingsFuture = this.executor.submit(() -> {
            RosettaPath path = RosettaPath.valueOf((String)instance.getType().getSimpleName());
            for (MappingDelegate mapper : this.mappingDelegates) {
                LOGGER.debug("Running mapper {} for model path {}", (Object)mapper.getClass().getSimpleName(), (Object)mapper.getModelPath());
                long t0 = System.currentTimeMillis();
                MappingBuilderProcessor processor = new MappingBuilderProcessor(mapper);
                processor.processRosetta(path, topClass, builder, null, new AttributeMeta[0]);
                long t = System.currentTimeMillis() - t0;
                if (t > 200L) {
                    LOGGER.debug("Took {} ms to run mapper {} for model path {}", new Object[]{t, mapper.getClass().getSimpleName(), mapper.getModelPath()});
                }
                builder.process(path, (BuilderProcessor)processor);
            }
            this.awaitCompletion(this.invokedTasks);
        });
        LOGGER.debug("Main thread waits for the mappers to complete before continuing");
        try {
            Uninterruptibles.getUninterruptibly(mappingsFuture, (long)this.mappingMaxTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e1) {
            LOGGER.error("Error running mapping processor", (Throwable)e1);
            this.context.getMappingErrors().add("Error running mapping processors: " + e1.getMessage());
        }
        catch (TimeoutException e1) {
            LOGGER.error("Timeout running mapping processor");
            this.context.getMappingErrors().add("Timeout running mapping processors");
        }
        LOGGER.info("Mappers completed in {}", (Object)stopwatch.stop());
        LOGGER.debug("Shutdown mapper thread pool");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                LOGGER.info("Failed to shutdown mapper executor in 200ms, force shutdown now");
                this.executor.shutdownNow();
            } else {
                LOGGER.debug("All mapper threads terminated");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Caught interrupted exception whilst running shutdownNow");
            this.executor.shutdownNow();
        }
        return null;
    }

    private void awaitCompletion(List<CompletableFuture<?>> invokedTasks) {
        try {
            CompletableFuture.allOf(invokedTasks.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupt during mapping invokedTasks", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause().getMessage(), e.getCause());
        }
    }

    private static class MappingBuilderProcessor
    implements BuilderProcessor {
        private final MappingDelegate delegate;
        private final RosettaPath modelPath;
        private final List<Path> synonymPaths;

        MappingBuilderProcessor(MappingDelegate delegate) {
            this.delegate = delegate;
            this.modelPath = delegate.getModelPath();
            this.synonymPaths = delegate.getSynonymPaths();
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath currentPath, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... meta) {
            if (currentPath.equals((Object)this.modelPath)) {
                this.synonymPaths.forEach(p -> this.delegate.map((Path)p, Optional.ofNullable(builder), parent));
            }
            return true;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath currentPath, Class<R> rosettaType, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent, AttributeMeta ... meta) {
            if (currentPath.equals((Object)this.modelPath)) {
                this.synonymPaths.forEach(p -> this.delegate.map((Path)p, Optional.ofNullable(builder).orElse(Collections.emptyList()), parent));
            }
            return true;
        }

        public <T> void processBasic(RosettaPath currentPath, Class<T> rosettaType, T instance, RosettaModelObjectBuilder parent, AttributeMeta ... meta) {
            if (currentPath.equals((Object)this.modelPath)) {
                this.synonymPaths.forEach(p -> this.delegate.mapBasic((Path)p, Optional.ofNullable(instance), parent));
            }
        }

        public <T> void processBasic(RosettaPath currentPath, Class<T> rosettaType, Collection<? extends T> instance, RosettaModelObjectBuilder parent, AttributeMeta ... meta) {
            if (currentPath.equals((Object)this.modelPath)) {
                this.synonymPaths.forEach(p -> this.delegate.mapBasic((Path)p, Optional.ofNullable(instance).orElse(Collections.emptyList()), parent));
            }
        }

        public BuilderProcessor.Report report() {
            return null;
        }
    }

    private static class PathComparator
    implements Comparator<MappingDelegate> {
        private PathComparator() {
        }

        @Override
        public int compare(MappingDelegate o1, MappingDelegate o2) {
            String path1 = o1.getModelPath().buildPath();
            String path2 = o2.getModelPath().buildPath();
            return o1.getModelPath().compareTo(o2.getModelPath());
        }
    }
}

