/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.translation;

import com.google.common.collect.ImmutableList;
import com.regnosys.rosetta.common.util.PathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Path {
    private static final String WILDCARD = "*";
    private final List<PathElement> elements;

    public Path() {
        this.elements = ImmutableList.of();
    }

    public Path(List<PathElement> elements) {
        this.elements = elements;
    }

    public static Path valueOf(List<String> path) {
        return new Path(path.stream().map(p -> new PathElement((String)p)).collect(Collectors.toList()));
    }

    public static Path valueOf(String path) {
        ArrayList<PathElement> newPath = new ArrayList<PathElement>();
        newPath.add(new PathElement(path));
        return new Path(newPath);
    }

    public Path addElement(PathElement element) {
        ArrayList<PathElement> newPath = new ArrayList<PathElement>();
        newPath.addAll(this.elements);
        newPath.add(element);
        return new Path(newPath);
    }

    public Path addElement(String name) {
        return this.addElement(new PathElement(name));
    }

    public Path addElement(String name, Integer index) {
        return this.addElement(new PathElement(name, Optional.ofNullable(index), Collections.emptyMap()));
    }

    public List<PathElement> getElements() {
        return this.elements;
    }

    public String[] getPathNames() {
        return (String[])this.elements.stream().map(PathElement::getPathName).toArray(String[]::new);
    }

    public Path getParent() {
        return new Path(this.elements.subList(0, this.elements.size() - 1));
    }

    public PathElement getLastElement() {
        if (this.elements.size() < 1) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public Path append(Path append) {
        ImmutableList list = ImmutableList.builder().addAll(this.elements).addAll(append.elements).build();
        return new Path((List<PathElement>)list);
    }

    public Path prefixWithWildcard() {
        return Path.valueOf(WILDCARD).append(this);
    }

    public Path trimFirst() {
        LinkedList<PathElement> elements = new LinkedList<PathElement>(this.getElements());
        elements.removeFirst();
        return new Path(elements);
    }

    public boolean nameStartMatches(Path other) {
        return this.nameStartMatches(other, false);
    }

    public boolean nameStartMatches(Path other, boolean allowWildcard) {
        if (this.elements.isEmpty() && other.elements.isEmpty()) {
            return true;
        }
        if (this.elements.isEmpty()) {
            return false;
        }
        if (this.elements.size() > other.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            String p2;
            String p1 = this.elements.get(i).pathName;
            if (p1.equals(p2 = other.elements.get(i).pathName) || this.wildcardMatches(allowWildcard, p1, p2)) continue;
            return false;
        }
        return true;
    }

    private boolean wildcardMatches(boolean allowWildcard, String p1, String p2) {
        return allowWildcard && (WILDCARD.equals(p1) || WILDCARD.equals(p2));
    }

    public boolean fullStartMatches(Path other) {
        return this.fullStartMatches(other, false);
    }

    public boolean fullStartMatches(Path other, boolean allowWildcard) {
        if (this.elements.isEmpty() && other.elements.isEmpty()) {
            return true;
        }
        if (this.elements.isEmpty()) {
            return false;
        }
        if (this.elements.size() > other.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            String p2;
            String p1 = this.elements.get(i).pathName;
            if (this.wildcardMatches(allowWildcard, p1, p2 = other.elements.get(i).pathName) || p1.equals(p2) && this.elements.get(i).index.orElse(0).intValue() == other.elements.get(i).index.orElse(0).intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean nameIndexMatches(Path other) {
        if (this.elements.isEmpty() && other.elements.isEmpty()) {
            return true;
        }
        if (this.elements.isEmpty()) {
            return false;
        }
        if (this.elements.size() != other.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i).pathName.equals(other.elements.get(i).pathName) && this.elements.get(i).index.orElse(0).intValue() == other.elements.get(i).index.orElse(0).intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String ... path) {
        int dif = this.elements.size() - path.length;
        if (dif < 0) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            PathElement el = this.elements.get(dif + i);
            String s = path[i];
            if (el.getPathName().equalsIgnoreCase(s)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(Path other) {
        int thisSize = this.elements.size();
        int otherSize = other.elements.size();
        if (otherSize > thisSize) {
            return false;
        }
        for (int i = 1; i <= otherSize; ++i) {
            if (this.elements.get(thisSize - i).equals(other.elements.get(otherSize - i))) continue;
            return false;
        }
        return true;
    }

    public int cardinality() {
        int result = -1;
        for (PathElement element : this.elements) {
            if (!element.index.isPresent() || result != -1) continue;
            result = (Integer)element.index.get();
        }
        if (result == -1) {
            return 0;
        }
        return result;
    }

    public static Path parse(String pathString) {
        return Path.parse(pathString, false);
    }

    public static Path parse(String pathString, boolean allowWildcard) {
        return new Path(Arrays.stream(pathString.split("\\.")).filter(s -> s.length() > 0).map(s -> PathElement.parse(s, allowWildcard)).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return this.elements.equals(path.elements);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public String toString() {
        return String.join((CharSequence)".", this.elements.stream().map(PathElement::toString).collect(Collectors.toList()));
    }

    public static class PathElement {
        private final String pathName;
        private Optional<Integer> index;
        private final Map<String, String> metas;
        private static Pattern pattern = Pattern.compile("(\\w*)(\\[(\\d*)])?");
        private static Pattern patternAllowWildcard = Pattern.compile("([*]|\\w*)(\\[(\\d*)])?");

        public PathElement(String pathName) {
            this(pathName, Optional.empty(), Collections.emptyMap());
        }

        public PathElement(String pathName, Map<String, String> metas) {
            this(pathName, Optional.empty(), metas);
        }

        public PathElement(String pathName, Optional<Integer> index, Map<String, String> metas) {
            Objects.nonNull(pathName);
            Objects.nonNull(index);
            Objects.nonNull(metas);
            this.pathName = pathName;
            this.index = index;
            this.metas = metas;
        }

        public PathElement(String pathName, int index) {
            this(pathName, Optional.of(index), Collections.emptyMap());
        }

        public PathElement(String pathName, int index, Map<String, String> metas) {
            this(pathName, Optional.of(index), metas);
        }

        public int forceGetIndex() {
            if (this.index.isPresent()) {
                return this.index.get();
            }
            this.index = Optional.of(0);
            return 0;
        }

        public Optional<Integer> getIndex() {
            return this.index;
        }

        public String getPathName() {
            return this.pathName;
        }

        public Map<String, String> getMetas() {
            return this.metas;
        }

        public String toString() {
            return this.pathName + this.index.map(i -> "(" + i + ")").orElse("");
        }

        public static PathElement parse(String s) {
            return PathElement.parse(s, false);
        }

        public static PathElement parse(String s, boolean allowWildcard) {
            Matcher match;
            Matcher matcher = match = allowWildcard ? patternAllowWildcard.matcher(s) : pattern.matcher(s);
            if (match.matches()) {
                String name = match.group(1);
                Optional<Integer> index = match.group(3) != null ? Optional.of(Integer.valueOf(match.group(3))) : Optional.empty();
                return new PathElement(name, index, Collections.emptyMap());
            }
            throw new PathException("Failed to parse path element " + s);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.pathName == null ? 0 : this.pathName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathElement other = (PathElement)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (!(this.metas == null || other.metas == null || this.metas.isEmpty() || other.metas.isEmpty() || this.metas.equals(other.metas))) {
                return false;
            }
            return !(this.pathName == null ? other.pathName != null : !this.pathName.equals(other.pathName));
        }
    }
}

