/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.translation.flat;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.flat.Capture;
import com.regnosys.rosetta.common.translation.flat.IndexCapturePath;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract class FlatFileMappingProcessor<TYPE extends RosettaModelObjectBuilder>
extends MappingProcessor {
    protected static final Path BASE_PATH = Path.parse("WorkflowStep");
    protected final DateTimeFormatter dateParser = DateTimeFormatter.BASIC_ISO_DATE;
    protected final DateTimeFormatter localTimeParser = DateTimeFormatter.ISO_LOCAL_TIME;
    private Multimap<IndexCapturePath, IndexCapturePath> pathLookup = ArrayListMultimap.create();
    private Multimap<IndexCapturePath, MappingConsumer<TYPE>> mappings = HashMultimap.create();
    private Multimap<String, Capture> captures = HashMultimap.create();
    private Collection<BiConsumer<Multimap<String, Capture>, TYPE>> postCaptureProcessors = new ArrayList<BiConsumer<Multimap<String, Capture>, TYPE>>();

    public FlatFileMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    protected BigDecimal parseDecimal(String value) {
        return new BigDecimal(value);
    }

    protected Date parseISODate(String value) {
        return Date.of((LocalDate)LocalDate.parse(value, this.dateParser));
    }

    @Override
    public void map(Path synonymPath, Optional<RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        RosettaModelObjectBuilder type = parent;
        HashSet<Mapping> inputs = new HashSet<Mapping>(this.getContext().getMappings());
        this.doHardCodings(type);
        ArrayList<Mapping> allMappings = new ArrayList<Mapping>();
        for (Mapping m : inputs) {
            String xmlPath = m.getXmlPath().toString();
            IndexCapturePath xmlCapturing = IndexCapturePath.parse(xmlPath);
            Collection capturers = this.pathLookup.get((Object)xmlCapturing.toUnindexed());
            boolean mapped = false;
            for (IndexCapturePath capturer : capturers) {
                if (!xmlCapturing.matches(capturer)) continue;
                Map<String, Integer> captureIndexes = capturer.captureIndexes(xmlCapturing);
                xmlCapturing.getLastIndex().ifPresent(i -> captureIndexes.put("other", (Integer)i));
                Collection mappingConsumers = this.mappings.get((Object)capturer);
                String xmlValue = m.getXmlValue() == null ? null : m.getXmlValue().toString();
                for (MappingConsumer mc : mappingConsumers) {
                    List<PathValue<?>> results = mc.accept(captureIndexes, xmlValue, new PathValue<RosettaModelObjectBuilder>(BASE_PATH, type));
                    for (PathValue<?> r : results) {
                        if (xmlValue == null) continue;
                        allMappings.add(new Mapping(m.getXmlPath(), xmlValue, ((PathValue)r).modelPath, ((PathValue)r).value, null, true, ((PathValue)r).conditional, false));
                    }
                }
                mapped = true;
            }
            if (mapped) continue;
            allMappings.add(m);
        }
        this.doConditionalStuff(type);
        this.updateMappings(allMappings);
    }

    private void updateMappings(List<Mapping> allMappings) {
        this.getContext().getMappings().clear();
        this.getContext().getMappings().addAll(allMappings);
    }

    @Override
    public <T> void mapBasic(Path synonymPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        super.map(synonymPath, Optional.empty(), parent);
    }

    @Override
    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        super.map(synonymPath, Optional.empty(), parent);
    }

    protected abstract void doHardCodings(TYPE var1);

    protected MappingConsumer<TYPE> nonNullConsumer(MappingConsumer<TYPE> consumer) {
        return (i, v, r) -> v != null ? consumer.accept(i, v, r) : Lists.newArrayList();
    }

    private void doConditionalStuff(TYPE workflow) {
        for (BiConsumer<Multimap<String, Capture>, TYPE> processor : this.postCaptureProcessors) {
            processor.accept(this.captures, workflow);
        }
    }

    protected <T> MappingConsumer<T> capture(String name) {
        return (indexes, value, workflow) -> {
            this.captures.put((Object)name, (Object)new Capture(indexes, value));
            return Lists.newArrayList((Object[])new PathValue[]{new PathValue<String>(workflow.getModelPath(), value, true)});
        };
    }

    protected void addMapping(IndexCapturePath path, MappingConsumer<TYPE> consumer) {
        this.pathLookup.put((Object)path.toUnindexed(), (Object)path);
        this.mappings.put((Object)path, consumer);
    }

    protected void addPostCaptureProcessors(BiConsumer<Multimap<String, Capture>, TYPE> postCaptureProcessor) {
        this.postCaptureProcessors.add(postCaptureProcessor);
    }

    protected <A> Optional<A> any(Collection<A> collection) {
        return collection.stream().findAny();
    }

    protected Optional<Capture> matchingIndex(Capture toMatch, Collection<Capture> lookIn, String ... matchOn) {
        Map<String, Integer> matchValues = Arrays.stream(matchOn).collect(Collectors.toMap(k -> k, k -> toMatch.getIndexes().get(k)));
        return lookIn.stream().filter(c -> this.matches((Capture)c, matchValues)).findFirst();
    }

    private boolean matches(Capture c, Map<String, Integer> matchValues) {
        Map<String, Integer> indexes = c.getIndexes();
        for (Map.Entry<String, Integer> matchValue : matchValues.entrySet()) {
            Integer val = indexes.get(matchValue.getKey());
            if (val.equals(matchValue.getValue())) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    protected static interface MappingConsumer<T> {
        public List<PathValue<?>> accept(Map<String, Integer> var1, String var2, PathValue<T> var3);
    }

    protected static class PathValue<T> {
        private final Path modelPath;
        private final T value;
        private final boolean conditional;

        public PathValue(Path modelPath, T value) {
            this(modelPath, value, false);
        }

        public PathValue(Path modelPath, T value, boolean conditional) {
            this.modelPath = modelPath;
            this.value = value;
            this.conditional = conditional;
        }

        public Path getModelPath() {
            return this.modelPath;
        }

        public T getValue() {
            return this.value;
        }
    }
}

