/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.validation;

import com.google.common.collect.Streams;
import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaTypeValidator
implements PostProcessStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(RosettaTypeValidator.class);
    @Inject
    private ValidatorFactory validatorFactory;

    public <T extends RosettaModelObject> ValidationReport runProcessStep(Class<? extends T> topClass, T instance) {
        LOGGER.debug("Running validation for " + instance.getType().getSimpleName());
        ValidationReport report = new ValidationReport(instance, new ArrayList());
        RosettaTypeProcessor processor = new RosettaTypeProcessor(report);
        RosettaPath path = RosettaPath.valueOf((String)instance.getType().getSimpleName());
        processor.processRosetta(path, topClass, instance, null, new AttributeMeta[0]);
        instance.process(path, (Processor)processor);
        return report;
    }

    public String getName() {
        return "Rosetta type validator PostProcessor";
    }

    public Integer getPriority() {
        return 100;
    }

    class RosettaTypeProcessor
    extends SimpleProcessor {
        private ValidationReport result;

        public RosettaTypeProcessor(ValidationReport report) {
            this.result = report;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
            if (instance == null) {
                return false;
            }
            RosettaMetaData metaData = instance.metaData();
            List<ValidationResult<?>> validationResults = this.result.getValidationResults();
            Streams.concat((Stream[])new Stream[]{metaData.dataRules(RosettaTypeValidator.this.validatorFactory).stream(), Optional.ofNullable(metaData.validator(RosettaTypeValidator.this.validatorFactory)).map(Stream::of).orElse(Stream.empty()), Optional.ofNullable(metaData.typeFormatValidator(RosettaTypeValidator.this.validatorFactory)).map(Stream::of).orElse(Stream.empty())}).forEach(validator -> validationResults.addAll(validator.getValidationResults(path, instance)));
            return true;
        }

        public Processor.Report report() {
            return this.result;
        }
    }
}

