/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.beans.Bean;
import org.joda.beans.DynamicBean;
import org.joda.beans.MetaBean;
import org.joda.beans.impl.flexi.FlexiBean;
import org.joda.beans.impl.map.MapBean;

final class MetaBeans {
    private static final ConcurrentHashMap<Class<?>, MetaBean> META_BEANS = new ConcurrentHashMap();

    private MetaBeans() {
    }

    static MetaBean lookup(Class<?> cls) {
        MetaBean meta = META_BEANS.get(cls);
        if (meta == null) {
            return MetaBeans.metaBeanLookup(cls);
        }
        return meta;
    }

    private static MetaBean metaBeanLookup(Class<?> cls) {
        if (cls == FlexiBean.class) {
            return new FlexiBean().metaBean();
        }
        if (cls == MapBean.class) {
            return new MapBean().metaBean();
        }
        if (DynamicBean.class.isAssignableFrom(cls)) {
            try {
                return cls.asSubclass(DynamicBean.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).metaBean();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Unable to find meta-bean for a DynamicBean: " + cls.getName(), ex);
            }
        }
        try {
            cls = Class.forName(cls.getName(), true, cls.getClassLoader());
        }
        catch (ClassNotFoundException | Error ex) {
            throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName(), ex);
        }
        MetaBean meta = META_BEANS.get(cls);
        if (meta == null) {
            throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName());
        }
        return meta;
    }

    static void register(MetaBean metaBean) {
        Class<? extends Bean> type = metaBean.beanType();
        if (META_BEANS.putIfAbsent(type, metaBean) != null) {
            throw new IllegalArgumentException("Cannot register class twice: " + type.getName());
        }
    }
}

