/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics;

import com.opengamma.strata.basics.CombinedReferenceData;
import com.opengamma.strata.basics.ImmutableReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.ReferenceDataNotFoundException;
import com.opengamma.strata.basics.StandardReferenceData;
import com.opengamma.strata.collect.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface ReferenceData {
    public static ReferenceData of(Map<? extends ReferenceDataId<?>, ?> values) {
        HashMap combined = new HashMap();
        combined.putAll((Map<ReferenceDataId<?>, Object>)StandardReferenceData.MINIMAL.getValues());
        combined.putAll(values);
        return ImmutableReferenceData.of(combined);
    }

    public static ReferenceData standard() {
        return StandardReferenceData.STANDARD;
    }

    public static ReferenceData minimal() {
        return StandardReferenceData.MINIMAL;
    }

    public static ReferenceData empty() {
        return ImmutableReferenceData.empty();
    }

    default public boolean containsValue(ReferenceDataId<?> id) {
        return this.findValue(id).isPresent();
    }

    default public <T> T getValue(ReferenceDataId<T> id) {
        return this.findValue(id).orElseThrow(() -> new ReferenceDataNotFoundException(Messages.format((String)"Reference data not found for '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()})));
    }

    public <T> Optional<T> findValue(ReferenceDataId<T> var1);

    default public <T> T queryValueOrNull(ReferenceDataId<T> id) {
        return this.findValue(id).orElse(null);
    }

    default public ReferenceData combinedWith(ReferenceData other) {
        return new CombinedReferenceData(this, other);
    }
}

