/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CurrencyAmountArray
implements FxConvertible<CurrencyAmountArray>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray values;
    private static final long serialVersionUID = 1L;

    public static CurrencyAmountArray of(Currency currency, DoubleArray values) {
        return new CurrencyAmountArray(currency, values);
    }

    public static CurrencyAmountArray of(List<CurrencyAmount> amounts) {
        Currency currency = amounts.stream().map(ca -> ca.getCurrency()).distinct().reduce(Guavate.ensureOnlyOne()).get();
        double[] values = amounts.stream().mapToDouble(ca -> ca.getAmount()).toArray();
        return new CurrencyAmountArray(currency, DoubleArray.ofUnsafe((double[])values));
    }

    public static CurrencyAmountArray of(int size, IntFunction<CurrencyAmount> valueFunction) {
        ArgChecker.notNegativeOrZero((int)size, (String)"size");
        double[] array = new double[size];
        CurrencyAmount ca0 = valueFunction.apply(0);
        Currency currency = ca0.getCurrency();
        array[0] = ca0.getAmount();
        for (int i = 1; i < size; ++i) {
            CurrencyAmount ca = valueFunction.apply(i);
            if (!ca.getCurrency().equals(currency)) {
                throw new IllegalArgumentException(Messages.format((String)"Currencies differ: {} and {}", (Object[])new Object[]{currency, ca.getCurrency()}));
            }
            array[i] = ca.getAmount();
        }
        return new CurrencyAmountArray(currency, DoubleArray.ofUnsafe((double[])array));
    }

    public int size() {
        return this.values.size();
    }

    public CurrencyAmount get(int index) {
        return CurrencyAmount.of(this.currency, this.values.get(index));
    }

    public Stream<CurrencyAmount> stream() {
        return this.values.stream().mapToObj(amount -> CurrencyAmount.of(this.currency, amount));
    }

    @Override
    public CurrencyAmountArray convertedTo(Currency resultCurrency, FxRateProvider fxRateProvider) {
        if (this.currency.equals(resultCurrency)) {
            return this;
        }
        double fxRate = fxRateProvider.fxRate(this.currency, resultCurrency);
        DoubleArray convertedValues = this.values.multipliedBy(fxRate);
        return new CurrencyAmountArray(resultCurrency, convertedValues);
    }

    public CurrencyAmountArray plus(CurrencyAmountArray other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException(Messages.format((String)"Sizes must be equal, this size is {}, other size is {}", (Object[])new Object[]{this.size(), other.size()}));
        }
        if (!other.currency.equals(this.currency)) {
            throw new IllegalArgumentException(Messages.format((String)"Currencies must be equal, this currency is {}, other currency is {}", (Object[])new Object[]{this.currency, other.currency}));
        }
        return CurrencyAmountArray.of(this.currency, this.values.plus(other.values));
    }

    public CurrencyAmountArray plus(CurrencyAmount amount) {
        if (!amount.getCurrency().equals(this.currency)) {
            throw new IllegalArgumentException(Messages.format((String)"Currencies must be equal, this currency is {}, other currency is {}", (Object[])new Object[]{this.currency, amount.getCurrency()}));
        }
        return CurrencyAmountArray.of(this.currency, this.values.plus(amount.getAmount()));
    }

    public CurrencyAmountArray minus(CurrencyAmountArray other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException(Messages.format((String)"Sizes must be equal, this size is {}, other size is {}", (Object[])new Object[]{this.size(), other.size()}));
        }
        if (!other.currency.equals(this.currency)) {
            throw new IllegalArgumentException(Messages.format((String)"Currencies must be equal, this currency is {}, other currency is {}", (Object[])new Object[]{this.currency, other.currency}));
        }
        return CurrencyAmountArray.of(this.currency, this.values.minus(other.values));
    }

    public CurrencyAmountArray minus(CurrencyAmount amount) {
        if (!amount.getCurrency().equals(this.currency)) {
            throw new IllegalArgumentException(Messages.format((String)"Currencies must be equal, this currency is {}, other currency is {}", (Object[])new Object[]{this.currency, amount.getCurrency()}));
        }
        return CurrencyAmountArray.of(this.currency, this.values.minus(amount.getAmount()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CurrencyAmountArray(Currency currency, DoubleArray values) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)values, (String)"values");
        this.currency = currency;
        this.values = values;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DoubleArray getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurrencyAmountArray other = (CurrencyAmountArray)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.values, (Object)other.values);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.values);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CurrencyAmountArray{");
        buf.append("currency").append('=').append(this.currency).append(',').append(' ');
        buf.append("values").append('=').append(JodaBeanUtils.toString((Object)this.values));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurrencyAmountArray> {
        private Currency currency;
        private DoubleArray values;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case -823812830: {
                    return this.values;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -823812830: {
                    this.values = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurrencyAmountArray build() {
            return new CurrencyAmountArray(this.currency, this.values);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CurrencyAmountArray.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("values").append('=').append(JodaBeanUtils.toString((Object)this.values));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CurrencyAmountArray.class, Currency.class);
        private final MetaProperty<DoubleArray> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", CurrencyAmountArray.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "values"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case -823812830: {
                    return this.values;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurrencyAmountArray> builder() {
            return new Builder();
        }

        public Class<? extends CurrencyAmountArray> beanType() {
            return CurrencyAmountArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DoubleArray> values() {
            return this.values;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((CurrencyAmountArray)bean).getCurrency();
                }
                case -823812830: {
                    return ((CurrencyAmountArray)bean).getValues();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

