/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
final class CombinedHolidayCalendar
implements HolidayCalendar,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final HolidayCalendar calendar1;
    @PropertyDefinition(validate="notNull")
    private final HolidayCalendar calendar2;
    private static final long serialVersionUID = 1L;

    @Override
    public HolidayCalendarId getId() {
        return this.calendar1.getId().combinedWith(this.calendar2.getId());
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        return this.calendar1.isHoliday(date) || this.calendar2.isHoliday(date);
    }

    public String toString() {
        return "HolidayCalendar[" + this.getName() + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    CombinedHolidayCalendar(HolidayCalendar calendar1, HolidayCalendar calendar2) {
        JodaBeanUtils.notNull((Object)calendar1, (String)"calendar1");
        JodaBeanUtils.notNull((Object)calendar2, (String)"calendar2");
        this.calendar1 = calendar1;
        this.calendar2 = calendar2;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public HolidayCalendar getCalendar1() {
        return this.calendar1;
    }

    public HolidayCalendar getCalendar2() {
        return this.calendar2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CombinedHolidayCalendar other = (CombinedHolidayCalendar)obj;
            return JodaBeanUtils.equal((Object)this.calendar1, (Object)other.calendar1) && JodaBeanUtils.equal((Object)this.calendar2, (Object)other.calendar2);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.calendar1);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.calendar2);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CombinedHolidayCalendar> {
        private HolidayCalendar calendar1;
        private HolidayCalendar calendar2;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1233097549: {
                    return this.calendar1;
                }
                case -1233097548: {
                    return this.calendar2;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1233097549: {
                    this.calendar1 = (HolidayCalendar)newValue;
                    break;
                }
                case -1233097548: {
                    this.calendar2 = (HolidayCalendar)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CombinedHolidayCalendar build() {
            return new CombinedHolidayCalendar(this.calendar1, this.calendar2);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CombinedHolidayCalendar.Builder{");
            buf.append("calendar1").append('=').append(JodaBeanUtils.toString((Object)this.calendar1)).append(',').append(' ');
            buf.append("calendar2").append('=').append(JodaBeanUtils.toString((Object)this.calendar2));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<HolidayCalendar> calendar1 = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"calendar1", CombinedHolidayCalendar.class, HolidayCalendar.class);
        private final MetaProperty<HolidayCalendar> calendar2 = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"calendar2", CombinedHolidayCalendar.class, HolidayCalendar.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"calendar1", "calendar2"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1233097549: {
                    return this.calendar1;
                }
                case -1233097548: {
                    return this.calendar2;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CombinedHolidayCalendar> builder() {
            return new Builder();
        }

        public Class<? extends CombinedHolidayCalendar> beanType() {
            return CombinedHolidayCalendar.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<HolidayCalendar> calendar1() {
            return this.calendar1;
        }

        public MetaProperty<HolidayCalendar> calendar2() {
            return this.calendar2;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1233097549: {
                    return ((CombinedHolidayCalendar)bean).getCalendar1();
                }
                case -1233097548: {
                    return ((CombinedHolidayCalendar)bean).getCalendar2();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

