/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import java.util.Optional;

public interface FloatingRateIndex
extends Index {
    public static FloatingRateIndex parse(String indexStr) {
        return FloatingRateIndex.parse(indexStr, null);
    }

    public static FloatingRateIndex parse(String indexStr, Tenor defaultIborTenor) {
        ArgChecker.notNull((Object)indexStr, (String)"indexStr");
        Optional iborOpt = IborIndex.extendedEnum().find(indexStr);
        if (iborOpt.isPresent()) {
            return (FloatingRateIndex)iborOpt.get();
        }
        Optional overnightOpt = OvernightIndex.extendedEnum().find(indexStr);
        if (overnightOpt.isPresent()) {
            return (FloatingRateIndex)overnightOpt.get();
        }
        Optional priceOpt = PriceIndex.extendedEnum().find(indexStr);
        if (priceOpt.isPresent()) {
            return (FloatingRateIndex)priceOpt.get();
        }
        Optional frnOpt = FloatingRateName.extendedEnum().find(indexStr);
        if (frnOpt.isPresent()) {
            FloatingRateName frn = (FloatingRateName)frnOpt.get();
            return frn.toFloatingRateIndex(defaultIborTenor != null ? defaultIborTenor : frn.getDefaultTenor());
        }
        throw new IllegalArgumentException("Floating rate index not known: " + indexStr);
    }

    public Currency getCurrency();

    public boolean isActive();

    public DayCount getDayCount();

    public FloatingRateName getFloatingRateName();

    default public DayCount getDefaultFixedLegDayCount() {
        return this.getDayCount();
    }
}

