/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum FloatingRateType implements NamedEnum
{
    IBOR,
    OVERNIGHT_COMPOUNDED,
    OVERNIGHT_AVERAGED,
    PRICE,
    OTHER;

    private static final EnumNames<FloatingRateType> NAMES;

    @FromString
    public static FloatingRateType of(String name) {
        return (FloatingRateType)NAMES.parse(name);
    }

    public boolean isIbor() {
        return this == IBOR;
    }

    public boolean isOvernight() {
        return this == OVERNIGHT_COMPOUNDED || this == OVERNIGHT_AVERAGED;
    }

    public boolean isPrice() {
        return this == PRICE;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(FloatingRateType.class);
    }
}

