/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party.processor;

import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.NaturalPersonRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.FieldWithMetaNaturalPersonRoleEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaNaturalPerson;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaturalPersonPartyMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaturalPersonPartyMappingProcessor.class);

    public NaturalPersonPartyMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        List relatedPersonPaths = this.getMappings().stream().filter(mapping -> mapping.getXmlPath().toString().contains(".relatedPerson")).map(Mapping::getXmlPath).collect(Collectors.toList());
        List<? extends RosettaModelObjectBuilder> nPRbuilder = builders;
        HashSet processedIndices = new HashSet();
        HashSet<Integer> processedPartyTradeInformationIndices = new HashSet<Integer>();
        HashSet<Integer> processedRelatedPersonIndices = new HashSet<Integer>();
        int previousPartyTradeInformationSize = 0;
        Party.PartyBuilder partyBuilder = (Party.PartyBuilder)parent;
        for (int i = 0; i < relatedPersonPaths.size(); ++i) {
            NaturalPersonRole.NaturalPersonRoleBuilder nPRCurrentbuilder;
            String pathStr = ((Path)relatedPersonPaths.get(i)).toString();
            int startIndex = pathStr.lastIndexOf("(");
            int endIndex = pathStr.lastIndexOf(")");
            if (startIndex == -1 || endIndex == -1) continue;
            int currentIndex = Integer.parseInt(pathStr.substring(startIndex + 1, endIndex));
            int partyTradeInformationIndex = this.extractPartyTradeInformationIndex(pathStr);
            if (processedPartyTradeInformationIndices.contains(partyTradeInformationIndex) && processedRelatedPersonIndices.contains(currentIndex)) continue;
            Optional<String> personReferenceHref = this.extractPersonReferenceHref((Path)relatedPersonPaths.get(i));
            Optional<String> roleValue = this.extractRoleValue((Path)relatedPersonPaths.get(i + 1));
            if (nPRbuilder.size() > currentIndex) {
                nPRCurrentbuilder = (NaturalPersonRole.NaturalPersonRoleBuilder)nPRbuilder.get(currentIndex);
            } else {
                nPRCurrentbuilder = NaturalPersonRole.builder();
                nPRbuilder.add((RosettaModelObjectBuilder)nPRCurrentbuilder);
            }
            personReferenceHref.ifPresent(pRH -> roleValue.ifPresent(rV -> {
                if (rV != null) {
                    try {
                        NaturalPersonRoleEnum roleEnum = null;
                        for (NaturalPersonRoleEnum enumValue : NaturalPersonRoleEnum.values()) {
                            if (!enumValue.toString().trim().equalsIgnoreCase(rV.trim())) continue;
                            roleEnum = enumValue;
                            break;
                        }
                        FieldWithMetaNaturalPersonRoleEnum.FieldWithMetaNaturalPersonRoleEnumBuilder fieldBuilder = FieldWithMetaNaturalPersonRoleEnum.builder();
                        FieldWithMetaNaturalPersonRoleEnum fieldWithMeta = fieldBuilder.setValue(roleEnum).build();
                        if (nPRCurrentbuilder.getRole().isEmpty() || nPRCurrentbuilder.getRole().stream().noneMatch(existingRole -> existingRole.getValue().equals((Object)fieldWithMeta.getValue()))) {
                            ArrayList<FieldWithMetaNaturalPersonRoleEnum> fieldList = new ArrayList<FieldWithMetaNaturalPersonRoleEnum>();
                            fieldList.add(fieldWithMeta);
                            nPRCurrentbuilder.addRole(fieldList);
                            nPRCurrentbuilder.setPersonReference(ReferenceWithMetaNaturalPerson.builder().setExternalReference(pRH).build());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error setting value for NaturalPersonRoleEnum: " + e.getMessage(), (Throwable)e);
                    }
                }
            }));
            processedPartyTradeInformationIndices.add(partyTradeInformationIndex);
            processedRelatedPersonIndices.add(currentIndex);
            if (processedPartyTradeInformationIndices.size() <= previousPartyTradeInformationSize || processedPartyTradeInformationIndices.size() <= 1) continue;
            processedRelatedPersonIndices.clear();
            previousPartyTradeInformationSize = processedPartyTradeInformationIndices.size();
            processedRelatedPersonIndices.add(currentIndex);
        }
    }

    private Integer extractPartyTradeInformationIndex(String pathStr) {
        int startIndex = pathStr.indexOf("partyTradeInformation(");
        int endIndex = pathStr.indexOf(")");
        try {
            if (startIndex != -1 && endIndex != -1) {
                String indexStr = pathStr.substring(startIndex + 21, endIndex);
                if (!(indexStr = indexStr.replaceAll("[^0-9]", "")).isEmpty()) {
                    return Integer.parseInt(indexStr);
                }
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error extracting partyTradeInformation index: " + e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private Optional<String> extractPersonReferenceHref(Path path) {
        return this.getMappings().stream().filter(mapping -> {
            String xmlPath = mapping.getXmlPath().toString();
            return xmlPath.endsWith(".personReference.href") && xmlPath.equals(path.toString());
        }).map(Mapping::getXmlValue).filter(Objects::nonNull).map(Object::toString).findFirst();
    }

    private Optional<String> extractRoleValue(Path path) {
        return this.getMappings().stream().filter(mapping -> {
            String xmlPath = mapping.getXmlPath().toString();
            return xmlPath.endsWith(".role") && xmlPath.equals(path.toString());
        }).map(Mapping::getXmlValue).filter(Objects::nonNull).map(Object::toString).findFirst();
    }
}

