/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.common.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.CollateralReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CollateralEnrichmentDataRuleDefault.class)
public abstract class CollateralEnrichmentDataRule
implements ReportFunction<CollateralReportInstruction, EnrichmentData> {
    @Inject
    protected ModelObjectValidator objectValidator;

    public EnrichmentData evaluate(CollateralReportInstruction input) {
        EnrichmentData output;
        EnrichmentData.EnrichmentDataBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(EnrichmentData.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract EnrichmentData.EnrichmentDataBuilder doEvaluate(CollateralReportInstruction var1);

    public static class CollateralEnrichmentDataRuleDefault
    extends CollateralEnrichmentDataRule {
        @Override
        protected EnrichmentData.EnrichmentDataBuilder doEvaluate(CollateralReportInstruction input) {
            EnrichmentData.EnrichmentDataBuilder output = EnrichmentData.builder();
            return this.assignOutput(output, input);
        }

        protected EnrichmentData.EnrichmentDataBuilder assignOutput(EnrichmentData.EnrichmentDataBuilder output, CollateralReportInstruction input) {
            output = (EnrichmentData.EnrichmentDataBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)input).mapSingleToItem(item -> item.map("getReportableInformation", collateralReportInstruction -> collateralReportInstruction.getReportableInformation()).map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment())).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

