/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.margin.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.projection.iso20022.asic.rewrite.margin.functions.Create_MarginReportData;
import drr.projection.iso20022.asic.rewrite.margin.labels.Project_ASICMarginReportToIso20022LabelProvider;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.regulation.common.MarginActionEnum;
import iso20022.auth108.asic.Document;
import iso20022.auth108.asic.MarginReportData9__1;
import iso20022.auth108.asic.TradeReport34Choice__1;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@RuneLabelProvider(labelProvider=Project_ASICMarginReportToIso20022LabelProvider.class)
@ImplementedBy(value=Project_ASICMarginReportToIso20022Default.class)
public abstract class Project_ASICMarginReportToIso20022
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_MarginReportData create_MarginReportData;

    public Document evaluate(ASICMarginReport marginReport) {
        Document iso20022Report;
        Document.DocumentBuilder iso20022ReportBuilder = this.doEvaluate(marginReport);
        if (iso20022ReportBuilder == null) {
            iso20022Report = null;
        } else {
            iso20022Report = iso20022ReportBuilder.build();
            this.objectValidator.validate(Document.class, (RosettaModelObject)iso20022Report);
        }
        return iso20022Report;
    }

    protected abstract Document.DocumentBuilder doEvaluate(ASICMarginReport var1);

    public static class Project_ASICMarginReportToIso20022Default
    extends Project_ASICMarginReportToIso20022 {
        @Override
        protected Document.DocumentBuilder doEvaluate(ASICMarginReport marginReport) {
            Document.DocumentBuilder iso20022Report = Document.builder();
            return this.assignOutput(iso20022Report, marginReport);
        }

        protected Document.DocumentBuilder assignOutput(Document.DocumentBuilder iso20022Report, ASICMarginReport marginReport) {
            MarginReportData9__1 ifThenElseResult0 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)marginReport).map("getActionType", aSICMarginReport -> aSICMarginReport.getActionType()), (Mapper)MapperS.of((Object)((Object)MarginActionEnum.MARU)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = this.create_MarginReportData.evaluate(marginReport);
            }
            MarginReportData9__1 ifThenElseResult1 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)marginReport).map("getActionType", aSICMarginReport -> aSICMarginReport.getActionType()), (Mapper)MapperS.of((Object)((Object)MarginActionEnum.CORR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = this.create_MarginReportData.evaluate(marginReport);
            }
            TradeReport34Choice__1 tradeReport34Choice__1 = TradeReport34Choice__1.builder().setMrgnUpd(ifThenElseResult0).setCrrctn(ifThenElseResult1).build();
            iso20022Report.getOrCreateDerivsTradMrgnDataRpt().getOrCreateTradData().setRpt(tradeReport34Choice__1 == null ? Collections.emptyList() : Collections.singletonList(tradeReport34Choice__1));
            return Optional.ofNullable(iso20022Report).map(o -> o.prune()).orElse(null);
        }
    }
}

