/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.projection.iso20022.asic.rewrite.trade.functions.Create_OptionBarrierLevel1Choice__1;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.asic.AmountAndDirection106__1;
import iso20022.auth030.asic.OptionOrSwaption11__1;
import iso20022.auth030.asic.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptnDefault.class)
public abstract class GetOptn
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected Create_OptionBarrierLevel1Choice__1 create_OptionBarrierLevel1Choice__1;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption11__1 evaluate(ASICTransactionReport drrReport) {
        OptionOrSwaption11__1 optn;
        OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption11__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(ASICTransactionReport var1);

    public static class GetOptnDefault
    extends GetOptn {
        @Override
        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(ASICTransactionReport drrReport) {
            OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, ASICTransactionReport drrReport) {
            String ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getSettlementCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getSettlementCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : null);
            optn = (OptionOrSwaption11__1.OptionOrSwaption11__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption11__1.builder().setStrkPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).map("getStrikePrice", aSICTransactionReport -> aSICTransactionReport.getStrikePrice()).mapSingleToItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", aSICTransactionReport -> aSICTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"OPTN"), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", aSICTransactionReport -> aSICTransactionReport.getContractType()), (Mapper)MapperS.of((Object)"SWPT"), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", aSICTransactionReport -> aSICTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"INTR"), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get(), 5, 3) : (String)item.map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperators.lessThan((Mapper)item.map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getStrikePriceDecimal", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceDecimal()).get();
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setDcml(ifThenElseResult3).build());
            }).get()).setCallAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getCallAmount", aSICTransactionReport -> aSICTransactionReport.getCallAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getCallCurrency", aSICTransactionReport -> aSICTransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPutAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getPutAmount", aSICTransactionReport -> aSICTransactionReport.getPutAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getPutCurrency", aSICTransactionReport -> aSICTransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumAmount()).get()).setCcy(ifThenElseResult).build()).setPrmPmtDt((Date)MapperS.of((Object)drrReport).map("getOptionPremiumPaymentDate", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumPaymentDate()).get()).setMtrtyDtOfUndrlyg((Date)MapperS.of((Object)drrReport).map("getMaturityDateOfTheUnderlying", aSICTransactionReport -> aSICTransactionReport.getMaturityDateOfTheUnderlying()).get()).setBrrrLvls(this.create_OptionBarrierLevel1Choice__1.evaluate(drrReport)).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

