/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.mas.rewrite.valuation.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.projection.iso20022.mas.rewrite.valuation.functions.Create_ValuationReport32Choice__1;
import drr.projection.iso20022.mas.rewrite.valuation.functions.Create_ValuationReportHeader;
import drr.projection.iso20022.mas.rewrite.valuation.labels.Project_MASValuationReportToIso20022LabelProvider;
import drr.regulation.mas.rewrite.valuation.MASValuationReport;
import iso20022.auth030.mas.Document;
import iso20022.auth030.mas.TradeReport33Choice__1;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@RuneLabelProvider(labelProvider=Project_MASValuationReportToIso20022LabelProvider.class)
@ImplementedBy(value=Project_MASValuationReportToIso20022Default.class)
public abstract class Project_MASValuationReportToIso20022
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ValuationReport32Choice__1 create_ValuationReport32Choice__1;
    @Inject
    protected Create_ValuationReportHeader create_ValuationReportHeader;

    public Document evaluate(MASValuationReport drrReport) {
        Document iso20022Report;
        Document.DocumentBuilder iso20022ReportBuilder = this.doEvaluate(drrReport);
        if (iso20022ReportBuilder == null) {
            iso20022Report = null;
        } else {
            iso20022Report = iso20022ReportBuilder.build();
            this.objectValidator.validate(Document.class, (RosettaModelObject)iso20022Report);
        }
        return iso20022Report;
    }

    protected abstract Document.DocumentBuilder doEvaluate(MASValuationReport var1);

    public static class Project_MASValuationReportToIso20022Default
    extends Project_MASValuationReportToIso20022 {
        @Override
        protected Document.DocumentBuilder doEvaluate(MASValuationReport drrReport) {
            Document.DocumentBuilder iso20022Report = Document.builder();
            return this.assignOutput(iso20022Report, drrReport);
        }

        protected Document.DocumentBuilder assignOutput(Document.DocumentBuilder iso20022Report, MASValuationReport drrReport) {
            iso20022Report.getOrCreateDerivsTradRpt().setRptHdr(this.create_ValuationReportHeader.evaluate());
            TradeReport33Choice__1 tradeReport33Choice__1 = this.create_ValuationReport32Choice__1.evaluate(drrReport);
            iso20022Report.getOrCreateDerivsTradRpt().getOrCreateTradData().setRpt(tradeReport33Choice__1 == null ? Collections.emptyList() : Collections.singletonList(tradeReport33Choice__1));
            return Optional.ofNullable(iso20022Report).map(o -> o.prune()).orElse(null);
        }
    }
}

