/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDEEventIdentifierRule;
import javax.inject.Inject;

@ImplementedBy(value=EventIdentifierRuleDefault.class)
public abstract class EventIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CDEEventIdentifierRule cDEEventIdentifierRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class EventIdentifierRuleDefault
    extends EventIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)MapperS.of((Object)input).mapSingleToItem(item -> {
                String string = this.cDEEventIdentifierRule.evaluate((TransactionReportInstruction)item.get());
                return string == null ? MapperS.ofNull() : MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build());
            }).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

