/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OtherPaymentReportTypeFormatValidator
implements Validator<OtherPaymentReport> {
    private List<ComparisonResult> getComparisonResults(OtherPaymentReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"paymentType", (String)o.getPaymentType(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"amount", (BigDecimal)o.getAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"payer", (String)o.getPayer(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"receiver", (String)o.getReceiver(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherPaymentReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"OtherPaymentReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"OtherPaymentReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"OtherPaymentReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"OtherPaymentReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

