/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.tr.reports;

import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Arrays;
import javax.inject.Inject;

@ImplementedBy(value=AssetClassRuleDefault.class)
public abstract class AssetClassRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected TradeForEvent tradeForEvent;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class AssetClassRuleDefault
    extends AssetClassRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()));
            output = (String)thenArg1.mapSingleToItem(item -> {
                Boolean boolean0 = this.qualify_AssetClass_InterestRate.evaluate((EconomicTerms)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)"InterestRate");
                }
                if (ExpressionOperators.onlyExists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()), Arrays.asList("contractualProduct", "index", "loan", "assetPool", "foreignExchange", "commodity", "security", "basket"), Arrays.asList("foreignExchange")).or(ExpressionOperators.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"ForeignExchange");
                }
                if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Credit.evaluate((EconomicTerms)item.get()))).or(ExpressionOperators.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getSecurity", product -> product.getSecurity())).and(ExpressionOperators.areEqual((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getSecurity", product -> product.getSecurity()).map("getSecurityType", security -> security.getSecurityType()), (Mapper)MapperS.of((Object)SecurityTypeEnum.DEBT), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"Credit");
                }
                if (ExpressionOperators.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout())).or(ExpressionOperators.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()))).or(ExpressionOperators.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"Commodity");
                }
                Boolean boolean1 = this.qualify_AssetClass_Equity.evaluate((EconomicTerms)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)"Equity");
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

