/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.CommodityCommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityLeg1Default.class)
public abstract class CommodityLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityCommodityLeg1 commodityCommodityLeg1;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;

    public CommodityPayout evaluate(Product product) {
        CommodityPayout commodityLeg1;
        CommodityPayout.CommodityPayoutBuilder commodityLeg1Builder = this.doEvaluate(product);
        if (commodityLeg1Builder == null) {
            commodityLeg1 = null;
        } else {
            commodityLeg1 = commodityLeg1Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)commodityLeg1);
        }
        return commodityLeg1;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends CommodityPayout> commodityPayouts(Product var1);

    public static class CommodityLeg1Default
    extends CommodityLeg1 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(Product product) {
            CommodityPayout.CommodityPayoutBuilder commodityLeg1 = CommodityPayout.builder();
            return this.assignOutput(commodityLeg1, product);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder commodityLeg1, Product product) {
            Boolean boolean1;
            Boolean boolean0 = this.isCommoditySwapFloatFloat.evaluate(product);
            commodityLeg1 = boolean0 != null && boolean0 != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityCommodityLeg1.evaluate(this.commodityPayouts(product).getMulti())) : ((boolean1 = this.isCommodityFloatingPriceForward.evaluate(product)) != null && boolean1 != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityPayouts(product).get()) : null);
            return Optional.ofNullable(commodityLeg1).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends CommodityPayout> commodityPayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout());
        }
    }
}

