/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.functions.Create_ContinuousPriceSchedule;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Create_ContinuousPriceScheduleImpl
extends Create_ContinuousPriceSchedule {
    @Override
    protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(List<? extends PriceReportablePeriod> reportablePeriods, Date endDate) {
        if (reportablePeriods == null || endDate == null) {
            return null;
        }
        LocalDate localEndDate = endDate.toLocalDate();
        List sortedPeriods = reportablePeriods.stream().sorted(Comparator.comparing(PriceReportablePeriod::getPeriodEffectiveDate)).collect(Collectors.toList());
        return IntStream.range(0, sortedPeriods.size()).mapToObj(i -> {
            PriceReportablePeriod priceReportablePeriod = (PriceReportablePeriod)sortedPeriods.get(i);
            PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriodBuilder = (PriceReportablePeriod.PriceReportablePeriodBuilder)this.toBuilder(priceReportablePeriod);
            LocalDate computedEndDate = i == sortedPeriods.size() - 1 ? localEndDate : ((PriceReportablePeriod)sortedPeriods.get(i + 1)).getPeriodEffectiveDate().toLocalDate().minusDays(1L);
            if (priceReportablePeriod.getPeriodEndDate() == null || priceReportablePeriod.getPeriodEndDate().toLocalDate().isBefore(localEndDate)) {
                reportablePeriodBuilder.setPeriodEndDate(Date.of((LocalDate)computedEndDate));
            }
            return reportablePeriodBuilder;
        }).collect(Collectors.toList());
    }
}

