/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.AdjustableOrAdjustedOrRelativeDateResolution;
import drr.regulation.common.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FXNearLegDefault.class)
public abstract class FXNearLeg
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AdjustableOrAdjustedOrRelativeDateResolution adjustableOrAdjustedOrRelativeDateResolution;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
    @Inject
    protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;

    public ForwardPayout evaluate(Product product) {
        ForwardPayout nearLegPayout;
        ForwardPayout.ForwardPayoutBuilder nearLegPayoutBuilder = this.doEvaluate(product);
        if (nearLegPayoutBuilder == null) {
            nearLegPayout = null;
        } else {
            nearLegPayout = nearLegPayoutBuilder.build();
            this.objectValidator.validate(ForwardPayout.class, (RosettaModelObject)nearLegPayout);
        }
        return nearLegPayout;
    }

    protected abstract ForwardPayout.ForwardPayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends ForwardPayout> forwardPayout(Product var1);

    public static class FXNearLegDefault
    extends FXNearLeg {
        @Override
        protected ForwardPayout.ForwardPayoutBuilder doEvaluate(Product product) {
            ForwardPayout.ForwardPayoutBuilder nearLegPayout = ForwardPayout.builder();
            return this.assignOutput(nearLegPayout, product);
        }

        protected ForwardPayout.ForwardPayoutBuilder assignOutput(ForwardPayout.ForwardPayoutBuilder nearLegPayout, Product product) {
            nearLegPayout = ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_Swap.evaluate(this.economicTermsForProduct.evaluate(product)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_NDS.evaluate(this.economicTermsForProduct.evaluate(product))))).and(ExpressionOperators.exists((Mapper)this.forwardPayout(product).map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate()))).getOrDefault(Boolean.valueOf(false)) != false ? (ForwardPayout.ForwardPayoutBuilder)this.toBuilder((RosettaModelObject)this.forwardPayout(product).min(item -> item.map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate())).get()) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_Swap.evaluate(this.economicTermsForProduct.evaluate(product)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_NDS.evaluate(this.economicTermsForProduct.evaluate(product))))).and(ExpressionOperators.exists((Mapper)this.forwardPayout(product).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).getOrDefault(Boolean.valueOf(false)) != false ? (ForwardPayout.ForwardPayoutBuilder)this.toBuilder((RosettaModelObject)this.forwardPayout(product).min(item -> MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate((AdjustableOrAdjustedOrRelativeDate)item.map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).get()))).get()) : null);
            return Optional.ofNullable(nearLegPayout).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends ForwardPayout> forwardPayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout());
        }
    }
}

