/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommodityForward;
import javax.inject.Inject;

@ImplementedBy(value=IsCommodityFixedPriceForwardDefault.class)
public abstract class IsCommodityFixedPriceForward
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommodityForward isCommodityForward;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    public static class IsCommodityFixedPriceForwardDefault
    extends IsCommodityFixedPriceForward {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCommodityForward.evaluate(product)), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()))).get();
            return result;
        }
    }
}

