/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsFXPerformanceDefault.class)
public abstract class IsFXPerformance
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    public static class IsFXPerformanceDefault
    extends IsFXPerformance {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).map("getObservable", observationTerms -> observationTerms.getObservable()).map("getCurrencyPair", observable -> observable.getCurrencyPair())).get();
            return result;
        }
    }
}

