/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsProductWithUnderlierDefault.class)
public abstract class IsProductWithUnderlier
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public Boolean evaluate(Product product) {
        Boolean productWithUnderlier = this.doEvaluate(product);
        return productWithUnderlier;
    }

    protected abstract Boolean doEvaluate(Product var1);

    protected abstract MapperS<? extends Payout> payout(Product var1);

    public static class IsProductWithUnderlierDefault
    extends IsProductWithUnderlier {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean productWithUnderlier = null;
            return this.assignOutput(productWithUnderlier, product);
        }

        protected Boolean assignOutput(Boolean productWithUnderlier, Product product) {
            productWithUnderlier = ExpressionOperators.exists((Mapper)this.payout(product).mapC("getOptionPayout", _payout -> _payout.getOptionPayout())).or(ExpressionOperators.exists((Mapper)this.payout(product).mapC("getForwardPayout", _payout -> _payout.getForwardPayout()))).get();
            return productWithUnderlier;
        }

        @Override
        protected MapperS<? extends Payout> payout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout());
        }
    }
}

