/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquityForward;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsEquitySwap;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import drr.regulation.common.functions.ProductForTrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Package_Contract_Price_MonetaryDefault.class)
public abstract class Package_Contract_Price_Monetary
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsEquitySwap isEquitySwap;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected Qualify_BaseProduct_EquityForward qualify_BaseProduct_EquityForward;
    @Inject
    protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;

    public List<? extends PriceSchedule> evaluate(Trade trade) {
        List prices;
        List<PriceSchedule.PriceScheduleBuilder> pricesBuilder = this.doEvaluate(trade);
        if (pricesBuilder == null) {
            prices = null;
        } else {
            prices = pricesBuilder.stream().map(PriceSchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceSchedule.class, prices);
        }
        return prices;
    }

    protected abstract List<PriceSchedule.PriceScheduleBuilder> doEvaluate(Trade var1);

    public static class Package_Contract_Price_MonetaryDefault
    extends Package_Contract_Price_Monetary {
        @Override
        protected List<PriceSchedule.PriceScheduleBuilder> doEvaluate(Trade trade) {
            ArrayList<PriceSchedule.PriceScheduleBuilder> prices = new ArrayList<PriceSchedule.PriceScheduleBuilder>();
            return this.assignOutput(prices, trade);
        }

        protected List<PriceSchedule.PriceScheduleBuilder> assignOutput(List<PriceSchedule.PriceScheduleBuilder> prices, Trade trade) {
            Boolean boolean0 = this.isEquitySwap.evaluate((TradableProduct)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                prices.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
            } else {
                Boolean boolean1 = this.qualify_BaseProduct_EquityForward.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)));
                if (boolean1 != null && boolean1.booleanValue()) {
                    prices.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
                } else {
                    Boolean boolean2 = this.isTotalReturnSwapDebtUnderlier.evaluate(this.productForTrade.evaluate(trade));
                    if (boolean2 != null && boolean2.booleanValue()) {
                        prices.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
                    } else {
                        Boolean boolean3 = this.qualify_InterestRate_Forward_Debt.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)));
                        if (boolean3 != null && boolean3.booleanValue()) {
                            prices.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
                        } else {
                            Boolean boolean4 = this.isCommoditySwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
                            if (boolean4 != null && boolean4.booleanValue()) {
                                prices.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
                            } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_AssetClass_InterestRate.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade)))), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                prices.addAll(this.toBuilder(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).get()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
                            } else {
                                prices.addAll(this.toBuilder(Collections.emptyList()));
                            }
                        }
                    }
                }
            }
            return Optional.ofNullable(prices).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

