/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingRoleEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReportingRegimeTradingCapacity")
@ImplementedBy(value=Default.class)
public interface ReportingRegimeTradingCapacity
extends Validator<ReportingRegime> {
    public static final String NAME = "ReportingRegimeTradingCapacity";
    public static final String DEFINITION = "if regimeName = RegimeNameEnum -> MAS and reportingRole = ReportingRoleEnum -> ReportingParty then tradingCapacity = ReportingRoleEnum -> Agent or tradingCapacity = ReportingRoleEnum -> Principal";

    public static class NoOp
    implements ReportingRegimeTradingCapacity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReportingRegimeTradingCapacity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
            ComparisonResult result = this.executeDataRule(reportingRegime);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReportingRegimeTradingCapacity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportingRegime", (RosettaPath)path, (String)ReportingRegimeTradingCapacity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReportingRegimeTradingCapacity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportingRegime", (RosettaPath)path, (String)ReportingRegimeTradingCapacity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReportingRegime reportingRegime) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getRegimeName", _reportingRegime -> _reportingRegime.getRegimeName()).map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.MAS)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getReportingRole", _reportingRegime -> _reportingRegime.getReportingRole()), (Mapper)MapperS.of((Object)((Object)ReportingRoleEnum.REPORTING_PARTY)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getTradingCapacity", _reportingRegime -> _reportingRegime.getTradingCapacity()), (Mapper)MapperS.of((Object)((Object)ReportingRoleEnum.AGENT)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getTradingCapacity", _reportingRegime -> _reportingRegime.getTradingCapacity()), (Mapper)MapperS.of((Object)((Object)ReportingRoleEnum.PRINCIPAL)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

